/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.parser;

import io.virtdata.ast.Assignment;
import io.virtdata.ast.BooleanArg;
import io.virtdata.ast.DoubleArg;
import io.virtdata.ast.Expression;
import io.virtdata.ast.FloatArg;
import io.virtdata.ast.FunctionCall;
import io.virtdata.ast.IntegerArg;
import io.virtdata.ast.LongArg;
import io.virtdata.ast.RefArg;
import io.virtdata.ast.StringArg;
import io.virtdata.ast.VirtDataAST;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.generated.VirtDataBaseListener;
import io.virtdata.generated.VirtDataParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataBuilder
extends VirtDataBaseListener {
    private static final Logger logger = LoggerFactory.getLogger(VirtDataBuilder.class);
    private VirtDataAST model = new VirtDataAST();
    private List<ErrorNode> errorNodes = new ArrayList<ErrorNode>();
    private Stack<VirtDataParser.VirtdataFlowContext> flowContexts = new Stack();
    private Stack<VirtDataParser.ExpressionContext> expressionContexts = new Stack();
    private Stack<VirtDataParser.VirtdataCallContext> callContexts = new Stack();
    private LinkedList<VirtDataFlow> flows = new LinkedList();
    private Stack<FunctionCall> calls = new Stack();
    private static Pattern escapePattern = Pattern.compile("\\.");

    @Override
    public void enterVirtdataRecipe(VirtDataParser.VirtdataRecipeContext ctx) {
        logger.trace("parsing virtdata lambda recipe.");
        this.flowContexts.clear();
        this.expressionContexts.clear();
        this.callContexts.clear();
        this.flows.clear();
    }

    @Override
    public void exitVirtdataRecipe(VirtDataParser.VirtdataRecipeContext ctx) {
        logger.trace("parsed virtdata recipe.");
    }

    @Override
    public void enterVirtdataFlow(VirtDataParser.VirtdataFlowContext ctx) {
        logger.trace("parsing virtdata flow...");
        this.flowContexts.push(ctx);
        this.flows.push(new VirtDataFlow());
        this.calls.clear();
        if (ctx.COMPOSE() != null) {
            logger.warn("The 'compose' keyword is no longer needed in lambda construction. It will be deprecated in the future.");
        }
    }

    @Override
    public void exitVirtdataFlow(VirtDataParser.VirtdataFlowContext ctx) {
        this.model.addFlow(this.flows.pop());
        this.flowContexts.pop();
    }

    @Override
    public void enterExpression(VirtDataParser.ExpressionContext ctx) {
        this.expressionContexts.push(ctx);
        this.flows.peek().addExpression(new Expression());
    }

    @Override
    public void exitLvalue(VirtDataParser.LvalueContext ctx) {
        this.flows.peek().getLastExpression().setAssignment(new Assignment(ctx.ID().getSymbol().getText()));
    }

    @Override
    public void exitExpression(VirtDataParser.ExpressionContext ctx) {
        this.expressionContexts.pop();
    }

    @Override
    public void enterVirtdataCall(VirtDataParser.VirtdataCallContext ctx) {
        this.callContexts.push(ctx);
        this.calls.push(new FunctionCall());
    }

    @Override
    public void exitVirtdataCall(VirtDataParser.VirtdataCallContext ctx) {
        FunctionCall topFunctionCall = this.calls.pop();
        if (this.calls.empty()) {
            this.flows.peek().getLastExpression().setCall(topFunctionCall);
        } else {
            this.calls.peek().addFunctionArg(topFunctionCall);
        }
        this.callContexts.pop();
    }

    @Override
    public void exitInputType(VirtDataParser.InputTypeContext ctx) {
        this.calls.peek().setInputType(ctx.getText());
    }

    @Override
    public void exitFuncName(VirtDataParser.FuncNameContext ctx) {
        this.calls.peek().setFuncName(ctx.getText());
    }

    @Override
    public void exitOutputType(VirtDataParser.OutputTypeContext ctx) {
        this.calls.peek().setOutputType(ctx.getText());
    }

    @Override
    public void exitRef(VirtDataParser.RefContext ctx) {
        this.calls.peek().addFunctionArg(new RefArg(ctx.ID().getText()));
    }

    @Override
    public void exitIntegerValue(VirtDataParser.IntegerValueContext ctx) {
        this.calls.peek().addFunctionArg(new IntegerArg(Integer.valueOf(ctx.getText())));
    }

    @Override
    public void exitBooleanValue(VirtDataParser.BooleanValueContext ctx) {
        this.calls.peek().addFunctionArg(new BooleanArg(Boolean.valueOf(ctx.getText())));
    }

    @Override
    public void exitFloatValue(VirtDataParser.FloatValueContext ctx) {
        this.calls.peek().addFunctionArg(new FloatArg(Float.valueOf(ctx.getText()).floatValue()));
    }

    @Override
    public void exitStringValue(VirtDataParser.StringValueContext ctx) {
        StringArg stringArg = new StringArg(ctx.getText());
        this.calls.peek().addFunctionArg(stringArg);
    }

    @Override
    public void exitDoubleValue(VirtDataParser.DoubleValueContext ctx) {
        this.calls.peek().addFunctionArg(new DoubleArg(Double.valueOf(ctx.getText().substring(0, ctx.getText().length() - 1))));
    }

    @Override
    public void exitLongValue(VirtDataParser.LongValueContext ctx) {
        this.calls.peek().addFunctionArg(new LongArg(Long.valueOf(ctx.getText().substring(0, ctx.getText().length() - 1))));
    }

    @Override
    public void visitTerminal(TerminalNode terminalNode) {
    }

    @Override
    public void visitErrorNode(ErrorNode errorNode) {
        super.visitErrorNode(errorNode);
        this.errorNodes.add(errorNode);
    }

    @Override
    public void enterEveryRule(ParserRuleContext parserRuleContext) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext parserRuleContext) {
    }

    public boolean hasErrors() {
        return this.errorNodes.size() > 0;
    }

    public List<ErrorNode> getErrorNodes() {
        return this.errorNodes;
    }

    public FunctionCall getVirtdataCall() {
        return this.calls.peek().getVirtdataCall(0);
    }

    public VirtDataAST getModel() {
        return this.model;
    }
}

