/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String[] split(String string, char delimiter) {
        int end;
        int delimeterCount = 0;
        int start = 0;
        while ((end = string.indexOf(delimiter, start)) != -1) {
            ++delimeterCount;
            start = end + 1;
        }
        String[] result = new String[delimeterCount + 1];
        start = 0;
        for (int i = 0; i < delimeterCount; ++i) {
            end = string.indexOf(delimiter, start);
            result[i] = string.substring(start, end);
            start = end + 1;
        }
        result[delimeterCount] = string.substring(start, string.length());
        return result;
    }

    public static String encodeUrl(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String encodeUrlIso(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String decodeUrl(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String decodeUrlIso(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String md5(String stringToEncode) {
        return StringUtils.digest(stringToEncode, "MD5", "UTF-8");
    }

    public static String sha1(String stringToEncode) {
        return StringUtils.digest(stringToEncode, "SHA-1", "UTF-8");
    }

    public static String digest(String string, String digestAlgo, String encoding) {
        try {
            MessageDigest digester = MessageDigest.getInstance(digestAlgo);
            digester.update(string.getBytes(encoding));
            return StringUtils.hex(digester.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS[value >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS[value & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] parseHex(String hex) {
        int length = hex.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Illegal string length: " + length);
        }
        int bytesLength = length / 2;
        byte[] bytes = new byte[bytesLength];
        int idxChar = 0;
        for (int i = 0; i < bytesLength; ++i) {
            int value = StringUtils.parseHexDigit(hex.charAt(idxChar++)) << 4;
            bytes[i] = (byte)(value |= StringUtils.parseHexDigit(hex.charAt(idxChar++)));
        }
        return bytes;
    }

    public static int parseHexDigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hex digit: " + c);
    }

    public static String resolveEntity(String entity) {
        if (entity.length() > 1 && entity.charAt(0) == '#') {
            if (entity.charAt(1) == 'x') {
                return String.valueOf((char)Integer.parseInt(entity.substring(2), 16));
            }
            return String.valueOf((char)Integer.parseInt(entity.substring(1)));
        }
        if (entity.equals("apos")) {
            return "'";
        }
        if (entity.equals("quot")) {
            return "\"";
        }
        if (entity.equals("gt")) {
            return ">";
        }
        if (entity.equals("lt")) {
            return "<";
        }
        if (entity.equals("amp")) {
            return "&";
        }
        return entity;
    }

    public static String ellipsize(String text, int maxLength) {
        return StringUtils.ellipsize(text, maxLength, "...");
    }

    public static String ellipsize(String text, int maxLength, String end) {
        if (text != null && text.length() > maxLength) {
            return text.substring(0, maxLength - end.length()) + end;
        }
        return text;
    }

    public static String[] splitLines(String text, boolean skipEmptyLines) {
        if (skipEmptyLines) {
            return text.split("[\n\r]+");
        }
        return text.split("\\r?\\n");
    }

    public static List<String> findLinesContaining(String text, String searchText) {
        String[] splitLinesSkipEmpty = StringUtils.splitLines(text, true);
        ArrayList<String> matching = new ArrayList<String>();
        for (String line : splitLinesSkipEmpty) {
            if (!line.contains(searchText)) continue;
            matching.add(line);
        }
        return matching;
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable != null) {
            char singleChar;
            StringBuilder buf = new StringBuilder();
            Iterator<?> it = iterable.iterator();
            char c = singleChar = separator.length() == 1 ? separator.charAt(0) : (char)'\u0000';
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                if (singleChar != '\u0000') {
                    buf.append(singleChar);
                    continue;
                }
                buf.append(separator);
            }
            return buf.toString();
        }
        return "";
    }

    public static String join(int[] array, String separator) {
        if (array != null) {
            StringBuilder buf = new StringBuilder(Math.max(16, (separator.length() + 1) * array.length));
            char singleChar = separator.length() == 1 ? separator.charAt(0) : (char)'\u0000';
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    if (singleChar != '\u0000') {
                        buf.append(singleChar);
                    } else {
                        buf.append(separator);
                    }
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return "";
    }

    public static String join(String[] array, String separator) {
        if (array != null) {
            StringBuilder buf = new StringBuilder(Math.max(16, (separator.length() + 1) * array.length));
            char singleChar = separator.length() == 1 ? separator.charAt(0) : (char)'\u0000';
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    if (singleChar != '\u0000') {
                        buf.append(singleChar);
                    } else {
                        buf.append(separator);
                    }
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return "";
    }
}

