/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import io.virtdata.api.composers.ComposerForIntToDoubleFunction;
import io.virtdata.api.composers.ComposerForIntToLongFunction;
import io.virtdata.api.composers.ComposerForIntUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForIntFunction
implements FunctionComposer<IntFunction<?>> {
    private final IntFunction<?> inner;

    public ComposerForIntFunction(IntFunction<?> intFunction) {
        this.inner = intFunction;
    }

    @Override
    public FunctionComposer<?> andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        Object obj = this.inner.apply(1);
        ValueType valueType = ValueType.valueOfAssignableClass(obj.getClass());
        switch (functionType) {
            case long_long: {
                switch (valueType) {
                    case LONG: {
                        IntToLongFunction intToLongFunction = n -> ((LongUnaryOperator)object).applyAsLong(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case DOUBLE: {
                        IntToLongFunction intToLongFunction = n -> ((LongUnaryOperator)object).applyAsLong(((Double)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case INT: {
                        IntToLongFunction intToLongFunction = n -> ((LongUnaryOperator)object).applyAsLong(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                }
                IntToLongFunction intToLongFunction = n -> ((LongUnaryOperator)object).applyAsLong(Double.valueOf(this.inner.apply(n).toString()).longValue());
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case long_T: {
                switch (valueType) {
                    case LONG: {
                        IntFunction<Object> intFunction = n -> ((LongFunction)object).apply((Long)this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                    case DOUBLE: {
                        IntFunction<Object> intFunction = n -> ((LongFunction)object).apply(((Double)this.inner.apply(n)).longValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                    case INT: {
                        IntFunction<Object> intFunction = n -> ((LongFunction)object).apply(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                }
                IntFunction<Object> intFunction = n -> ((LongFunction)object).apply(Double.valueOf(this.inner.apply(n).toString()).longValue());
                return new ComposerForIntFunction(intFunction);
            }
            case long_int: {
                switch (valueType) {
                    case LONG: {
                        IntUnaryOperator intUnaryOperator = n -> ((LongToIntFunction)object).applyAsInt((Long)this.inner.apply(n));
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case DOUBLE: {
                        IntUnaryOperator intUnaryOperator = n -> ((LongToIntFunction)object).applyAsInt(((Double)this.inner.apply(n)).longValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case INT: {
                        IntUnaryOperator intUnaryOperator = n -> ((LongToIntFunction)object).applyAsInt(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                }
                IntUnaryOperator intUnaryOperator = n -> ((LongToIntFunction)object).applyAsInt(Double.valueOf(this.inner.apply(n).toString()).longValue());
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case long_double: {
                switch (valueType) {
                    case LONG: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((LongToDoubleFunction)object).applyAsDouble((Long)this.inner.apply(n));
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case DOUBLE: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((LongToDoubleFunction)object).applyAsDouble(((Double)this.inner.apply(n)).longValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case INT: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((LongToDoubleFunction)object).applyAsDouble(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                }
                IntToDoubleFunction intToDoubleFunction = n -> ((LongToDoubleFunction)object).applyAsDouble(Double.valueOf(this.inner.apply(n).toString()).longValue());
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case int_int: {
                switch (valueType) {
                    case LONG: {
                        IntUnaryOperator intUnaryOperator = n -> ((IntUnaryOperator)object).applyAsInt(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case DOUBLE: {
                        IntUnaryOperator intUnaryOperator = n -> ((IntUnaryOperator)object).applyAsInt(((Double)this.inner.apply(n)).intValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case INT: {
                        IntUnaryOperator intUnaryOperator = n -> ((IntUnaryOperator)object).applyAsInt((Integer)this.inner.apply(n));
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                }
                IntUnaryOperator intUnaryOperator = n -> ((IntUnaryOperator)object).applyAsInt(Double.valueOf(this.inner.apply(n).toString()).intValue());
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case R_T: {
                switch (valueType) {
                    case LONG: {
                        IntFunction<Object> intFunction = n -> ((Function)object).apply(this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                    case INT: {
                        IntFunction<Object> intFunction = n -> ((IntFunction)object).apply((Integer)this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                    case DOUBLE: {
                        IntFunction<Object> intFunction = n -> ((Function)object).apply(this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                }
                IntFunction<Object> intFunction = n -> ((Function)object).apply(this.inner.apply(n));
                return new ComposerForIntFunction(intFunction);
            }
            case int_long: {
                switch (valueType) {
                    case LONG: {
                        IntToLongFunction intToLongFunction = n -> ((IntToLongFunction)object).applyAsLong(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case INT: {
                        IntToLongFunction intToLongFunction = n -> ((IntToLongFunction)object).applyAsLong((Integer)this.inner.apply(n));
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case DOUBLE: {
                        IntToLongFunction intToLongFunction = n -> ((IntToLongFunction)object).applyAsLong(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                }
                IntToLongFunction intToLongFunction = n -> ((IntToLongFunction)object).applyAsLong(Double.valueOf(this.inner.apply(n).toString()).intValue());
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case int_double: {
                switch (valueType) {
                    case LONG: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((IntToDoubleFunction)object).applyAsDouble(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case INT: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((IntToDoubleFunction)object).applyAsDouble((Integer)this.inner.apply(n));
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case DOUBLE: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((IntToDoubleFunction)object).applyAsDouble(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                }
                IntToDoubleFunction intToDoubleFunction = n -> ((IntToDoubleFunction)object).applyAsDouble(Double.valueOf(this.inner.apply(n).toString()).intValue());
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case int_T: {
                switch (valueType) {
                    case LONG: {
                        IntFunction<Object> intFunction = n -> ((IntFunction)object).apply(((Long)this.inner.apply(n)).intValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                    case INT: {
                        IntFunction<Object> intFunction = n -> ((IntFunction)object).apply((Integer)this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                    case DOUBLE: {
                        IntFunction<Object> intFunction = n -> ((IntFunction)object).apply(((Double)this.inner.apply(n)).intValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                }
                IntFunction<Object> intFunction = n -> ((IntFunction)object).apply(Double.valueOf(this.inner.apply(n).toString()).intValue());
                return new ComposerForIntFunction(intFunction);
            }
            case double_double: {
                switch (valueType) {
                    case LONG: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((DoubleUnaryOperator)object).applyAsDouble(((Long)this.inner.apply(n)).longValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case DOUBLE: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((DoubleUnaryOperator)object).applyAsDouble((Double)this.inner.apply(n));
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                    case INT: {
                        IntToDoubleFunction intToDoubleFunction = n -> ((DoubleUnaryOperator)object).applyAsDouble(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntToDoubleFunction(intToDoubleFunction);
                    }
                }
                IntToDoubleFunction intToDoubleFunction = n -> ((DoubleUnaryOperator)object).applyAsDouble(Double.valueOf(this.inner.apply(n).toString()));
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case double_long: {
                switch (valueType) {
                    case LONG: {
                        IntToLongFunction intToLongFunction = n -> ((DoubleToLongFunction)object).applyAsLong(((Long)this.inner.apply(n)).longValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case DOUBLE: {
                        IntToLongFunction intToLongFunction = n -> ((DoubleToLongFunction)object).applyAsLong((Double)this.inner.apply(n));
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                    case INT: {
                        IntToLongFunction intToLongFunction = n -> ((DoubleToLongFunction)object).applyAsLong(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntToLongFunction(intToLongFunction);
                    }
                }
                IntToLongFunction intToLongFunction = n -> ((DoubleToLongFunction)object).applyAsLong(Double.valueOf(this.inner.apply(n).toString()));
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case double_int: {
                switch (valueType) {
                    case LONG: {
                        IntUnaryOperator intUnaryOperator = n -> ((DoubleToIntFunction)object).applyAsInt(((Long)this.inner.apply(n)).longValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case DOUBLE: {
                        IntUnaryOperator intUnaryOperator = n -> ((DoubleToIntFunction)object).applyAsInt((Double)this.inner.apply(n));
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                    case INT: {
                        IntUnaryOperator intUnaryOperator = n -> ((DoubleToIntFunction)object).applyAsInt(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntUnaryOperator(intUnaryOperator);
                    }
                }
                IntUnaryOperator intUnaryOperator = n -> ((DoubleToIntFunction)object).applyAsInt(Double.valueOf(this.inner.apply(n).toString()));
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case double_T: {
                switch (valueType) {
                    case LONG: {
                        IntFunction<Object> intFunction = n -> ((DoubleFunction)object).apply(((Long)this.inner.apply(n)).longValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                    case DOUBLE: {
                        IntFunction<Object> intFunction = n -> ((DoubleFunction)object).apply((Double)this.inner.apply(n));
                        return new ComposerForIntFunction(intFunction);
                    }
                    case INT: {
                        IntFunction<Object> intFunction = n -> ((DoubleFunction)object).apply(((Integer)this.inner.apply(n)).intValue());
                        return new ComposerForIntFunction(intFunction);
                    }
                }
                IntFunction<Object> intFunction = n -> ((DoubleFunction)object).apply(Double.valueOf(this.inner.apply(n).toString()));
                return new ComposerForIntFunction(intFunction);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }
}

