/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForIntFunction;
import io.virtdata.api.composers.ComposerForIntToLongFunction;
import io.virtdata.api.composers.ComposerForIntUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForIntToDoubleFunction
implements FunctionComposer<IntToDoubleFunction> {
    private final IntToDoubleFunction inner;

    public ComposerForIntToDoubleFunction(IntToDoubleFunction intToDoubleFunction) {
        this.inner = intToDoubleFunction;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer<?> andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        switch (functionType) {
            case long_long: {
                IntToLongFunction intToLongFunction = n -> ((LongUnaryOperator)object).applyAsLong((int)this.inner.applyAsDouble(n));
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case long_T: {
                IntFunction<Object> intFunction = n -> ((LongFunction)object).apply((int)this.inner.applyAsDouble(n));
                return new ComposerForIntFunction(intFunction);
            }
            case long_int: {
                IntUnaryOperator intUnaryOperator = n -> ((LongToIntFunction)object).applyAsInt((int)this.inner.applyAsDouble(n));
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case long_double: {
                IntToDoubleFunction intToDoubleFunction = n -> ((LongToDoubleFunction)object).applyAsDouble((int)this.inner.applyAsDouble(n));
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case int_int: {
                IntUnaryOperator intUnaryOperator = n -> ((IntUnaryOperator)object).applyAsInt((int)this.inner.applyAsDouble(n));
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case R_T: {
                IntFunction<Object> intFunction = n -> ((Function)object).apply(this.inner.applyAsDouble(n));
                return new ComposerForIntFunction(intFunction);
            }
            case int_long: {
                IntToLongFunction intToLongFunction = n -> ((IntToLongFunction)object).applyAsLong((int)this.inner.applyAsDouble(n));
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case int_double: {
                IntToDoubleFunction intToDoubleFunction = n -> ((IntToDoubleFunction)object).applyAsDouble((int)this.inner.applyAsDouble(n));
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case int_T: {
                IntFunction<Object> intFunction = n -> ((IntFunction)object).apply((int)this.inner.applyAsDouble(n));
                return new ComposerForIntFunction(intFunction);
            }
            case double_double: {
                IntToDoubleFunction intToDoubleFunction = n -> ((DoubleUnaryOperator)object).applyAsDouble(this.inner.applyAsDouble(n));
                return new ComposerForIntToDoubleFunction(intToDoubleFunction);
            }
            case double_long: {
                IntToLongFunction intToLongFunction = n -> ((DoubleToLongFunction)object).applyAsLong(this.inner.applyAsDouble(n));
                return new ComposerForIntToLongFunction(intToLongFunction);
            }
            case double_int: {
                IntUnaryOperator intUnaryOperator = n -> ((DoubleToIntFunction)object).applyAsInt(this.inner.applyAsDouble(n));
                return new ComposerForIntUnaryOperator(intUnaryOperator);
            }
            case double_T: {
                IntFunction<Object> intFunction = n -> ((DoubleFunction)object).apply(this.inner.applyAsDouble(n));
                return new ComposerForIntFunction(intFunction);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }
}

