/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import io.virtdata.api.composers.ComposerForLongToDoubleFunction;
import io.virtdata.api.composers.ComposerForLongToIntFunction;
import io.virtdata.api.composers.ComposerForLongUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposerForLongFunction
implements FunctionComposer<LongFunction<?>> {
    private static final Logger logger = LoggerFactory.getLogger(ComposerForLongFunction.class);
    private final LongFunction<?> inner;

    public ComposerForLongFunction(LongFunction<?> longFunction) {
        this.inner = longFunction;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        Object obj = this.inner.apply(1L);
        ValueType valueType = ValueType.valueOfAssignableClass(obj.getClass());
        switch (functionType) {
            case long_long: {
                switch (valueType) {
                    case LONG: {
                        LongUnaryOperator longUnaryOperator = l -> ((LongUnaryOperator)object).applyAsLong((Long)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case DOUBLE: {
                        LongUnaryOperator longUnaryOperator = l -> ((LongUnaryOperator)object).applyAsLong(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case INT: {
                        LongUnaryOperator longUnaryOperator = l -> ((LongUnaryOperator)object).applyAsLong(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                }
                LongUnaryOperator longUnaryOperator = l -> ((LongUnaryOperator)object).applyAsLong(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case long_T: {
                switch (valueType) {
                    case LONG: {
                        LongFunction<Object> longFunction = l -> ((LongFunction)object).apply((Long)this.inner.apply(l));
                        return new ComposerForLongFunction(longFunction);
                    }
                    case DOUBLE: {
                        LongFunction<Object> longFunction = l -> ((LongFunction)object).apply(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                    case INT: {
                        LongFunction<Object> longFunction = l -> ((LongFunction)object).apply(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                }
                LongFunction<Object> longFunction = l -> ((LongFunction)object).apply(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongFunction(longFunction);
            }
            case long_int: {
                switch (valueType) {
                    case LONG: {
                        LongToIntFunction longToIntFunction = l -> ((LongToIntFunction)object).applyAsInt((Long)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case DOUBLE: {
                        LongToIntFunction longToIntFunction = l -> ((LongToIntFunction)object).applyAsInt(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case INT: {
                        LongToIntFunction longToIntFunction = l -> ((LongToIntFunction)object).applyAsInt(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                }
                LongToIntFunction longToIntFunction = l -> ((LongToIntFunction)object).applyAsInt(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case long_double: {
                switch (valueType) {
                    case LONG: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((LongToDoubleFunction)object).applyAsDouble((Long)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((LongToDoubleFunction)object).applyAsDouble(((Double)this.inner.apply(l)).longValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case INT: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((LongToDoubleFunction)object).applyAsDouble(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                }
                LongToDoubleFunction longToDoubleFunction = l -> ((LongToDoubleFunction)object).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()).longValue());
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case R_T: {
                LongFunction<Object> longFunction = l -> ((Function)object).apply(this.inner.apply(l));
                return new ComposerForLongFunction(longFunction);
            }
            case int_int: {
                switch (valueType) {
                    case LONG: {
                        LongToIntFunction longToIntFunction = l -> ((IntUnaryOperator)object).applyAsInt(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case INT: {
                        LongToIntFunction longToIntFunction = l -> ((IntUnaryOperator)object).applyAsInt((Integer)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case DOUBLE: {
                        LongToIntFunction longToIntFunction = l -> ((IntUnaryOperator)object).applyAsInt(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                }
                LongToIntFunction longToIntFunction = l -> ((IntUnaryOperator)object).applyAsInt(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case int_long: {
                switch (valueType) {
                    case LONG: {
                        LongUnaryOperator longUnaryOperator = l -> ((IntToLongFunction)object).applyAsLong(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case INT: {
                        LongUnaryOperator longUnaryOperator = l -> ((IntToLongFunction)object).applyAsLong((Integer)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case DOUBLE: {
                        LongUnaryOperator longUnaryOperator = l -> ((IntToLongFunction)object).applyAsLong(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                }
                LongUnaryOperator longUnaryOperator = l -> ((IntToLongFunction)object).applyAsLong(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case int_double: {
                switch (valueType) {
                    case LONG: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((IntToDoubleFunction)object).applyAsDouble(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((IntToDoubleFunction)object).applyAsDouble(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case INT: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((IntToDoubleFunction)object).applyAsDouble((Integer)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                }
                LongToDoubleFunction longToDoubleFunction = l -> ((IntToDoubleFunction)object).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case int_T: {
                switch (valueType) {
                    case LONG: {
                        LongFunction<Object> longFunction = l -> ((IntFunction)object).apply(((Long)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                    case DOUBLE: {
                        LongFunction<Object> longFunction = l -> ((IntFunction)object).apply(((Double)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                    case INT: {
                        LongFunction<Object> longFunction = l -> ((IntFunction)object).apply((Integer)this.inner.apply(l));
                        return new ComposerForLongFunction(longFunction);
                    }
                }
                LongFunction<Object> longFunction = l -> ((IntFunction)object).apply(Double.valueOf(this.inner.apply(l).toString()).intValue());
                return new ComposerForLongFunction(longFunction);
            }
            case double_double: {
                switch (valueType) {
                    case LONG: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((DoubleUnaryOperator)object).applyAsDouble(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case DOUBLE: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((DoubleUnaryOperator)object).applyAsDouble((Double)this.inner.apply(l));
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                    case INT: {
                        LongToDoubleFunction longToDoubleFunction = l -> ((DoubleUnaryOperator)object).applyAsDouble(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToDoubleFunction(longToDoubleFunction);
                    }
                }
                LongToDoubleFunction longToDoubleFunction = l -> ((DoubleUnaryOperator)object).applyAsDouble(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case double_long: {
                switch (valueType) {
                    case LONG: {
                        LongUnaryOperator longUnaryOperator = l -> ((DoubleToLongFunction)object).applyAsLong(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case INT: {
                        LongUnaryOperator longUnaryOperator = l -> ((DoubleToLongFunction)object).applyAsLong(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                    case DOUBLE: {
                        LongUnaryOperator longUnaryOperator = l -> ((DoubleToLongFunction)object).applyAsLong((Double)this.inner.apply(l));
                        return new ComposerForLongUnaryOperator(longUnaryOperator);
                    }
                }
                LongUnaryOperator longUnaryOperator = l -> ((DoubleToLongFunction)object).applyAsLong(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case double_int: {
                switch (valueType) {
                    case LONG: {
                        LongToIntFunction longToIntFunction = l -> ((DoubleToIntFunction)object).applyAsInt(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case INT: {
                        LongToIntFunction longToIntFunction = l -> ((DoubleToIntFunction)object).applyAsInt(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                    case DOUBLE: {
                        LongToIntFunction longToIntFunction = l -> ((DoubleToIntFunction)object).applyAsInt((Double)this.inner.apply(l));
                        return new ComposerForLongToIntFunction(longToIntFunction);
                    }
                }
                LongToIntFunction longToIntFunction = l -> ((DoubleToIntFunction)object).applyAsInt(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case double_T: {
                switch (valueType) {
                    case LONG: {
                        LongFunction<Object> longFunction = l -> ((DoubleFunction)object).apply(((Long)this.inner.apply(l)).longValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                    case DOUBLE: {
                        LongFunction<Object> longFunction = l -> ((DoubleFunction)object).apply((Double)this.inner.apply(l));
                        return new ComposerForLongFunction(longFunction);
                    }
                    case INT: {
                        LongFunction<Object> longFunction = l -> ((DoubleFunction)object).apply(((Integer)this.inner.apply(l)).intValue());
                        return new ComposerForLongFunction(longFunction);
                    }
                }
                LongFunction<Object> longFunction = l -> ((DoubleFunction)object).apply(Double.valueOf(this.inner.apply(l).toString()));
                return new ComposerForLongFunction(longFunction);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }
}

