/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForLongFunction;
import io.virtdata.api.composers.ComposerForLongToDoubleFunction;
import io.virtdata.api.composers.ComposerForLongToIntFunction;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForLongUnaryOperator
implements FunctionComposer<LongUnaryOperator> {
    private LongUnaryOperator inner;

    public ComposerForLongUnaryOperator(LongUnaryOperator longUnaryOperator) {
        this.inner = longUnaryOperator;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer<?> andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        switch (functionType) {
            case long_long: {
                LongUnaryOperator longUnaryOperator = l -> ((LongUnaryOperator)object).applyAsLong(this.inner.applyAsLong(l));
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case long_T: {
                LongFunction<Object> longFunction = l -> ((LongFunction)object).apply(this.inner.applyAsLong(l));
                return new ComposerForLongFunction(longFunction);
            }
            case long_int: {
                LongToIntFunction longToIntFunction = l -> ((LongToIntFunction)object).applyAsInt(this.inner.applyAsLong(l));
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case long_double: {
                LongToDoubleFunction longToDoubleFunction = l -> ((LongToDoubleFunction)object).applyAsDouble(this.inner.applyAsLong(l));
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case R_T: {
                LongFunction<Object> longFunction = l -> ((Function)object).apply(this.inner.applyAsLong(l));
                return new ComposerForLongFunction(longFunction);
            }
            case int_int: {
                LongToIntFunction longToIntFunction = l -> ((IntUnaryOperator)object).applyAsInt((int)this.inner.applyAsLong(l));
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case int_long: {
                LongUnaryOperator longUnaryOperator = l -> ((IntToLongFunction)object).applyAsLong((int)this.inner.applyAsLong(l));
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case int_double: {
                LongToDoubleFunction longToDoubleFunction = l -> ((IntToDoubleFunction)object).applyAsDouble((int)this.inner.applyAsLong(l));
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case int_T: {
                LongFunction<Object> longFunction = l -> ((IntFunction)object).apply((int)this.inner.applyAsLong(l));
                return new ComposerForLongFunction(longFunction);
            }
            case double_double: {
                LongToDoubleFunction longToDoubleFunction = l -> ((DoubleUnaryOperator)object).applyAsDouble(this.inner.applyAsLong(l));
                return new ComposerForLongToDoubleFunction(longToDoubleFunction);
            }
            case double_long: {
                LongUnaryOperator longUnaryOperator = l -> ((DoubleToLongFunction)object).applyAsLong(this.inner.applyAsLong(l));
                return new ComposerForLongUnaryOperator(longUnaryOperator);
            }
            case double_int: {
                LongToIntFunction longToIntFunction = l -> ((DoubleToIntFunction)object).applyAsInt(this.inner.applyAsLong(l));
                return new ComposerForLongToIntFunction(longToIntFunction);
            }
            case double_T: {
                LongFunction<Object> longFunction = l -> ((DoubleFunction)object).apply(this.inner.applyAsLong(l));
                return new ComposerForLongFunction(longFunction);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }
}

