/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.core.LazyValuesMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bindings {
    private static final Logger logger = LoggerFactory.getLogger(Bindings.class);
    private BindingsTemplate template;
    private List<DataMapper<?>> dataMappers = new ArrayList();
    private ThreadLocal<Map<String, DataMapper<?>>> nameCache;

    public Bindings(final BindingsTemplate bindingsTemplate, final List<DataMapper<?>> list) {
        this.template = bindingsTemplate;
        this.dataMappers = list;
        this.nameCache = ThreadLocal.withInitial(() -> new HashMap<String, DataMapper<?>>(){
            {
                for (int i = 0; i < bindingsTemplate.getBindPointNames().size(); ++i) {
                    this.put(bindingsTemplate.getBindPointNames().get(i), (DataMapper)list.get(i));
                }
            }
        });
    }

    public String toString() {
        return this.template.toString() + this.dataMappers;
    }

    public Object[] getAll(long l) {
        Object[] objectArray = new Object[this.dataMappers.size()];
        int n = 0;
        for (DataMapper<?> dataMapper : this.dataMappers) {
            objectArray[n++] = dataMapper.get(l);
        }
        return objectArray;
    }

    public BindingsTemplate getTemplate() {
        return this.template;
    }

    public Map<String, Object> getAllMap(long l) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.setMap(hashMap, l);
        return hashMap;
    }

    public List<Map<String, Object>> getIteratedMaps(long l, int n) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(n);
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.setMap(hashMap, l + (long)i);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public Map<String, Object> getIteratedSuffixMap(long l, int n) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(n * this.dataMappers.size());
        this.setIteratedSuffixMap(linkedHashMap, l, n);
        return linkedHashMap;
    }

    public Map<String, Object> getIteratedSuffixMap(long l, int n, String ... stringArray) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(n * stringArray.length);
        this.setIteratedSuffixMap(linkedHashMap, l, n, stringArray);
        return linkedHashMap;
    }

    private void setIteratedSuffixMap(Map<String, Object> map, long l, int n, String[] stringArray) {
        for (int i = 0; i < n; ++i) {
            for (String string : stringArray) {
                map.put(string + i, this.get(string, l + (long)i));
            }
        }
    }

    public Object get(int n, long l) {
        return this.dataMappers.get(n).get(l);
    }

    public Object get(String string, long l) {
        DataMapper<?> dataMapper = this.nameCache.get().get(string);
        return dataMapper.get(l);
    }

    public void setMap(Map<String, Object> map, long l) {
        Object[] objectArray = this.getAll(l);
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(this.template.getBindPointNames().get(i), objectArray[i]);
        }
    }

    public void setSuffixedMap(Map<String, Object> map, long l, String string) {
        Object[] objectArray = this.getAll(l);
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(this.template.getBindPointNames().get(i) + string, objectArray[i]);
        }
    }

    public void setIteratedSuffixMap(Map<String, Object> map, long l, long l2) {
        int n = 0;
        while ((long)n < l2) {
            this.setSuffixedMap(map, l + (long)n, String.valueOf(n));
            ++n;
        }
    }

    public void updateMap(Map<String, Object> map, long l) {
        for (String string : map.keySet()) {
            map.put(string, this.get(string, l));
        }
    }

    public void setNamedFields(FieldSetter fieldSetter, long l, String ... stringArray) {
        for (String string : stringArray) {
            fieldSetter.setField(string, this.get(string, l));
        }
    }

    public void setNamedFieldsIterated(FieldSetter fieldSetter, long l, int n, String ... stringArray) {
        for (int i = 0; i < n; ++i) {
            for (String string : stringArray) {
                fieldSetter.setField(string + i, this.get(string, l + (long)i));
            }
        }
    }

    public void setAllFields(FieldSetter fieldSetter, long l) {
        Object[] objectArray = this.getAll(l);
        for (int i = 0; i < objectArray.length; ++i) {
            fieldSetter.setField(this.template.getBindPointNames().get(i), objectArray[i]);
        }
    }

    public void setAllFieldsIterated(FieldSetter fieldSetter, long l, int n) {
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.getAll(l + (long)i);
            for (int j = 0; j < objectArray.length; ++j) {
                fieldSetter.setField(this.template.getBindPointNames().get(i) + i, objectArray[i]);
            }
        }
    }

    public LazyValuesMap getLazyMap(long l) {
        return new LazyValuesMap(this, l);
    }

    public static interface FieldSetter {
        public void setField(String var1, Object var2);
    }
}

