/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilityFixups {
    private static final Logger logger = LoggerFactory.getLogger(CompatibilityFixups.class);
    private static final Map<String, String> funcs = new HashMap<String, String>(){
        {
            this.put("log_normal", "LogNormal");
            this.put("normal", "Normal");
            this.put("levy", "Levy");
            this.put("nakagami", "Nakagami");
            this.put("exponential", "Exponential");
            this.put("logistic", "Logistic");
            this.put("laplace", "Laplace");
            this.put("cauchy", "Cauchy");
            this.put("f", "F");
            this.put("t", "T");
            this.put("weibull", "Weibull");
            this.put("chi_squared", "ChiSquared");
            this.put("gumbel", "Gumbel");
            this.put("beta", "Beta");
            this.put("pareto", "Pareto");
            this.put("gamma", "Gamma");
            this.put("uniform_real", "Uniform");
            this.put("uniform_integer", "Uniform");
            this.put("hypergeometric", "Hypergeometric");
            this.put("geometric", "Geometric");
            this.put("poisson", "Poisson");
            this.put("zipf", "Zipf");
            this.put("binomial", "Binomial");
            this.put("pascal", "Pascal");
        }
    };
    private static final String MAPTO = "mapto_";
    private static final String HASHTO = "hashto_";
    private static final String COMPUTE = "compute_";
    private static final String INTERPOLATE = "interpolate_";
    private static final Pattern oldcurve = Pattern.compile("(?<name>\\b[\\w_]+)(?<lparen>\\()(?<args>.*?)(?<rparen>\\))");
    private static final CompatibilityFixups instance = new CompatibilityFixups();

    public static String fixup(String string) {
        String string2 = instance.fix(string);
        if (!string2.equals(string)) {
            logger.warn(string + "' was preprocessed to '" + string2 + "'. Please change to the new one to avoid this warning.");
        }
        return string2;
    }

    public String fix(String string) {
        Matcher matcher = oldcurve.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(string.substring(n, matcher.start()));
            String string2 = this.fixCurveCall(matcher.group("name"), matcher.group("args"));
            stringBuilder.append(string2);
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private String fixCurveCall(String string, String object) {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        if (string.contains(MAPTO)) {
            string = string.replaceAll(MAPTO, "");
            bl = true;
        }
        if (string.contains(HASHTO)) {
            string = string.replaceAll(HASHTO, "");
            bl = false;
        }
        if (string.contains(COMPUTE)) {
            string = string.replaceAll(COMPUTE, "");
            bl2 = true;
        }
        if (string.contains(INTERPOLATE)) {
            string = string.replaceAll(INTERPOLATE, "");
            bl2 = false;
        }
        if ((string2 = funcs.get(string)) != null) {
            string = string2;
            object = bl ? (String)object + ",'map'" : (String)object + ",'hash'";
            object = bl2 ? (String)object + ",'compute'" : (String)object + ",'interpolate'";
        }
        return string + "(" + (String)object + ")";
    }
}

