/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapperLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMapperLibraryFinder {
    private static final Logger logger = LoggerFactory.getLogger(DataMapperLibrary.class);
    private static final Map<String, DataMapperLibrary> libraries = new ConcurrentHashMap<String, DataMapperLibrary>();

    private DataMapperLibraryFinder() {
    }

    public static synchronized DataMapperLibrary get(String string) {
        Optional<DataMapperLibrary> optional = Optional.ofNullable(DataMapperLibraryFinder.getLibraries().get(string));
        return optional.orElseThrow(() -> new RuntimeException("DataMapperLibrary '" + string + "' not found."));
    }

    private static synchronized Map<String, DataMapperLibrary> getLibraries() {
        if (libraries.size() == 0) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            logger.debug("loading DataMapper Libraries");
            ServiceLoader<DataMapperLibrary> serviceLoader = ServiceLoader.load(DataMapperLibrary.class);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (DataMapperLibrary dataMapperLibrary : serviceLoader) {
                logger.debug("Found data mapper library:" + dataMapperLibrary.getClass().getCanonicalName() + ":" + dataMapperLibrary.getLibraryName());
                if (libraries.get(dataMapperLibrary.getLibraryName()) != null) {
                    String string = dataMapperLibrary.getLibraryName();
                    hashMap.put(string, hashMap.getOrDefault(string, 0));
                }
                libraries.put(dataMapperLibrary.getLibraryName(), dataMapperLibrary);
            }
            if (hashMap.size() > 0) {
                logger.trace("Java runtime provided duplicates for " + hashMap.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",")));
            }
        }
        logger.info("Loaded DataMapper Libraries:" + libraries.keySet());
        return libraries;
    }

    public static synchronized List<DataMapperLibrary> getAll() {
        ArrayList<DataMapperLibrary> arrayList = new ArrayList<DataMapperLibrary>(DataMapperLibraryFinder.getLibraries().values());
        arrayList.sort((dataMapperLibrary, dataMapperLibrary2) -> dataMapperLibrary.getLibraryName().compareTo(dataMapperLibrary2.getLibraryName()));
        return Collections.unmodifiableList(arrayList);
    }
}

