/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.core.Bindings;
import io.virtdata.core.BindingsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LazyValuesMap
implements Map<String, Object> {
    private final Bindings bindings;
    private final BindingsCache bindingsCache;
    private final long input;

    public LazyValuesMap(Bindings bindings, long l) {
        this.bindings = bindings;
        this.bindingsCache = new BindingsCache(bindings);
        this.input = l;
    }

    @Override
    public int size() {
        return this.bindings.getTemplate().getBindPointNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.bindings.getTemplate().getBindPointNames().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.bindings.getTemplate().getBindPointNames().contains((String)object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.bindings.getTemplate().getDataMapperSpecs().contains((String)object);
    }

    @Override
    public Object get(Object object) {
        return this.bindingsCache.getField((String)object, this.input);
    }

    @Override
    public Object put(String string, Object object) {
        return this.bindingsCache.getCachedMap().put(string, object);
    }

    @Override
    public Object remove(Object object) {
        return this.bindingsCache.getCachedMap().remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.bindingsCache.getCachedMap().putAll(map);
    }

    @Override
    public void clear() {
        this.bindingsCache.getCachedMap().clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.addAll(LazyValuesMap.this.bindings.getTemplate().getBindPointNames());
            }
        });
    }

    @Override
    public Collection<Object> values() {
        return this.bindingsCache.getCachedMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.bindingsCache.getCachedMap().entrySet();
    }
}

