/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.core.stathelpers;

import io.virtdata.libbasics.core.stathelpers.EvProbD;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.DoubleToIntFunction;
import java.util.stream.Collectors;

public class AliasSamplerDoubleInt
implements DoubleToIntFunction {
    private ByteBuffer stats;
    private double slotCount;
    private static int _r0 = 0;
    private static int _r1 = _r0 + 8;
    private static int _r2 = _r1 + 4;
    public static int RECORD_LEN = _r2 + 4;

    AliasSamplerDoubleInt(ByteBuffer byteBuffer) {
        this.stats = byteBuffer;
        if (byteBuffer.capacity() % RECORD_LEN != 0) {
            throw new RuntimeException("Misaligned ByteBuffer size, must be a multiple of " + RECORD_LEN);
        }
        this.slotCount = byteBuffer.capacity() / RECORD_LEN;
    }

    public AliasSamplerDoubleInt(List<EvProbD> list) {
        Object object;
        int n = list.size();
        int[] nArray = new int[list.size()];
        double[] dArray = new double[list.size()];
        LinkedList<EvProbD> linkedList = new LinkedList<EvProbD>();
        LinkedList linkedList2 = new LinkedList();
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        double d = list.stream().mapToDouble(EvProbD::getProbability).sum();
        list = list.stream().map(evProbD -> new EvProbD(evProbD.getEventId(), evProbD.getProbability() / d * (double)n)).collect(Collectors.toList());
        for (EvProbD object2 : list) {
            (object2.getProbability() < 1.0 ? linkedList : linkedList2).addLast(object2);
        }
        while (linkedList.peekFirst() != null && linkedList2.peekFirst() != null) {
            object = (EvProbD)linkedList.removeFirst();
            EvProbD evProbD2 = (EvProbD)linkedList2.removeFirst();
            arrayList.add(new Slot(evProbD2.getEventId(), ((EvProbD)object).getEventId(), ((EvProbD)object).getProbability()));
            evProbD2.setProbability(evProbD2.getProbability() + ((EvProbD)object).getProbability() - 1.0);
            (evProbD2.getProbability() < 1.0 ? linkedList : linkedList2).addLast(evProbD2);
        }
        while (linkedList2.peekFirst() != null) {
            object = (EvProbD)linkedList2.removeFirst();
            arrayList.add(new Slot(((EvProbD)object).getEventId(), ((EvProbD)object).getEventId(), 1.0));
        }
        while (linkedList.peekFirst() != null) {
            object = (EvProbD)linkedList.removeFirst();
            arrayList.add(new Slot(((EvProbD)object).getEventId(), ((EvProbD)object).getEventId(), 1.0));
        }
        if (arrayList.size() != n) {
            throw new RuntimeException("basis for average probability is incorrect, because only " + arrayList.size() + " slotCount of " + n + " were created.");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((Slot)arrayList.get(i)).rescale(i, i + 1);
        }
        this.stats = ByteBuffer.allocate(arrayList.size() * RECORD_LEN);
        for (Slot slot : arrayList) {
            this.stats.putDouble(slot.botProb);
            this.stats.putInt(slot.botItx);
            this.stats.putInt(slot.topIdx);
        }
        this.stats.flip();
        this.slotCount = this.stats.capacity() / RECORD_LEN;
    }

    @Override
    public int applyAsInt(double d) {
        int n;
        double d2 = d * this.slotCount;
        double d3 = this.stats.getDouble(n = (int)d2 * RECORD_LEN);
        int n2 = n + (d2 > d3 ? _r2 : _r1);
        int n3 = this.stats.getInt(n2);
        return n3;
    }

    private static class Slot {
        public int topIdx;
        public int botItx;
        public double botProb;

        public Slot(int n, int n2, double d) {
            this.topIdx = n;
            this.botItx = n2;
            this.botProb = d;
        }

        public String toString() {
            return "top:" + this.topIdx + ", bot:" + this.botItx + ", botProb: " + this.botProb;
        }

        public Slot rescale(double d, double d2) {
            this.botProb = d + this.botProb * (d2 - d);
            return this;
        }
    }
}

