/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.distributions;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.stathelpers.AliasSamplerDoubleInt;
import io.virtdata.libbasics.core.stathelpers.EvProbD;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import io.virtdata.util.VirtDataResources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@Categories(value={Category.general})
@ThreadSafeMapper
public class WeightedStringsFromCSV
implements LongFunction<String> {
    private final String[] filenames;
    private final String valueColumn;
    private final String weightColumn;
    private final String[] lines;
    private final AliasSamplerDoubleInt sampler;
    private Hash hash;

    public WeightedStringsFromCSV(String string, String string2, String ... stringArray) {
        this.filenames = stringArray;
        this.valueColumn = string;
        this.weightColumn = string2;
        ArrayList<EvProbD> arrayList = new ArrayList<EvProbD>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray[0].equals("map")) {
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            this.hash = null;
        } else {
            if (stringArray[0].equals("hash")) {
                stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            }
            this.hash = new Hash();
        }
        for (String string3 : stringArray) {
            CSVParser cSVParser = VirtDataResources.readFileCSV(string3, new String[0]);
            for (CSVRecord cSVRecord : cSVParser) {
                String string4 = cSVRecord.get(string);
                arrayList2.add(string4);
                String string5 = cSVRecord.get(string2);
                arrayList.add(new EvProbD(arrayList2.size() - 1, Double.valueOf(string5)));
            }
        }
        this.sampler = new AliasSamplerDoubleInt(arrayList);
        this.lines = arrayList2.toArray(new String[0]);
    }

    @Override
    public String apply(long l) {
        if (this.hash != null) {
            l = this.hash.applyAsLong(l);
        }
        double d = (double)l / 9.223372036854776E18;
        int n = this.sampler.applyAsInt(d);
        return this.lines[n];
    }
}

