/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.HashRange;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.collections})
public class HashedRangeToLongList
implements LongFunction<List<Long>> {
    private final HashRange valueRange;
    private final HashRange sizeRange;

    public HashedRangeToLongList(int n, int n2, int n3, int n4) {
        if (n3 >= n4 || n3 >= n4) {
            throw new RuntimeException("HashedRangeToLongList must have minval, maxval, minsize, maxsize, where min<max.");
        }
        this.valueRange = new HashRange(n, n2);
        this.sizeRange = new HashRange(n3, n4);
    }

    @Override
    public List<Long> apply(long l) {
        long l2 = this.sizeRange.applyAsLong(l);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        while ((long)n < l2) {
            arrayList.add(this.valueRange.applyAsLong(l + (long)n));
            ++n;
        }
        return arrayList;
    }
}

