/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashSet;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class Set
implements LongFunction<java.util.Set<Object>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"Set(HashRange(3,7),Add(15L))", "create a set between 3 and 7 elements of Long values"})
    public Set(LongToIntFunction longToIntFunction, LongFunction<Object> longFunction) {
        this.sizeFunc = longToIntFunction;
        this.valueFunc = longFunction;
    }

    @Override
    public java.util.Set<Object> apply(long l) {
        int n = this.sizeFunc.applyAsInt(l);
        HashSet<Object> hashSet = new HashSet<Object>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.valueFunc.apply(l + (long)i));
        }
        return hashSet;
    }
}

