/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringList
implements LongFunction<List<String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"StringList(HashRange(3,7),Add(15L))", "create a list between 3 and 7 elements of String representations of Long values"})
    public StringList(LongToIntFunction longToIntFunction, LongFunction<Object> longFunction) {
        this.sizeFunc = longToIntFunction;
        this.valueFunc = longFunction;
    }

    @Override
    public List<String> apply(long l) {
        int n = this.sizeFunc.applyAsInt(l);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.valueFunc.apply(l + (long)i).toString());
        }
        return arrayList;
    }
}

