/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class HashedDoubleRange
implements LongToDoubleFunction {
    private final double min;
    private final double max;
    private final double interval;
    private static final double MAX_DOUBLE_VIA_LONG = 9.223372036854776E18;
    private final Hash hash = new Hash();

    public HashedDoubleRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.interval = d2 - d;
    }

    @Override
    public double applyAsDouble(long l) {
        long l2 = this.hash.applyAsLong(l);
        double d = (double)l2 / 9.223372036854776E18;
        double d2 = this.interval * d + this.min;
        return d2;
    }
}

