/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_inetaddress;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToInetAddress
implements LongFunction<InetAddress> {
    @Override
    public InetAddress apply(long l) {
        int n = (int)l % Integer.MAX_VALUE;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            return Inet4Address.getByAddress(byteBuffer.array());
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new RuntimeException(unknownHostException);
        }
    }
}

