/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Example;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.LongUnaryOperator;
import org.greenrobot.essentials.hash.Murmur3F;

public class HostHash
implements LongUnaryOperator {
    private static long hostHash = HostHash.computeHostHash();
    private ByteBuffer bb = ByteBuffer.allocate(8);
    private Murmur3F murmur3F = new Murmur3F((int)hostHash % Integer.MAX_VALUE);

    @Example(value={"HostHash()", "a simple per-host hash function"})
    public HostHash() {
    }

    @Example(value={"HostHash(2343)", "further permute the host hash with a specific seed"})
    public HostHash(int n) {
        this.murmur3F.update(n);
        this.murmur3F = new Murmur3F((int)this.murmur3F.getValue() & Integer.MAX_VALUE);
    }

    private static long computeHostHash() {
        try {
            Object object;
            Object object2;
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                hashSet.add(((NetworkInterface)object2).getDisplayName());
                hashSet.add(((NetworkInterface)object2).getName());
                object = ((NetworkInterface)object2).getInetAddresses();
                while (object.hasMoreElements()) {
                    InetAddress inetAddress2 = object.nextElement();
                    hashSet.add(inetAddress2.getHostName());
                    hashSet.add(inetAddress2.getHostAddress());
                }
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(null);
            Arrays.stream(inetAddressArray).forEach(inetAddress -> {
                hashSet.add(inetAddress.getCanonicalHostName());
                hashSet.add(inetAddress.getHostAddress());
                hashSet.add(inetAddress.getHostName());
            });
            object2 = new ArrayList(hashSet);
            object2.sort(String::compareTo);
            object = new Murmur3F(0);
            ((Murmur3F)object).reset();
            hashSet.forEach(arg_0 -> HostHash.lambda$computeHostHash$1((Murmur3F)object, arg_0));
            return ((Murmur3F)object).getValue();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public long applyAsLong(long l) {
        this.murmur3F.reset();
        this.bb.putLong(0, l);
        this.murmur3F.update(this.bb.array(), 0, 8);
        long l2 = Math.abs(this.murmur3F.getValue());
        return l2;
    }

    private static /* synthetic */ void lambda$computeHostHash$1(Murmur3F murmur3F, String string) {
        murmur3F.update(string.getBytes(StandardCharsets.UTF_8));
    }
}

