/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_object;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_double.HashedDoubleRange;
import io.virtdata.util.VirtDataFunctions;
import java.util.function.Function;
import java.util.function.LongFunction;

@Categories(value={Category.distributions})
@ThreadSafeMapper
public class CoinFunc
implements Function<Long, Object> {
    private final double threshold;
    private final LongFunction first;
    private final LongFunction second;
    private final HashedDoubleRange cointoss = new HashedDoubleRange(0.0, 1.0);

    @Example(value={"CoinFunc(0.15,NumberNameToString(),Combinations('A:1:B:23'))", "use the first function 15% of the time"})
    public CoinFunc(double d, Object object, Object object2) {
        this.threshold = d;
        this.first = VirtDataFunctions.adapt(object, LongFunction.class, Object.class, true);
        this.second = VirtDataFunctions.adapt(object2, LongFunction.class, Object.class, true);
    }

    @Override
    public Object apply(Long l) {
        double d = this.cointoss.applyAsDouble(l);
        Object r = d < this.threshold ? this.first.apply(l) : this.second.apply(l);
        return r;
    }
}

