/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_object;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class CoinFuncAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "CoinFunc";
    }

    @Override
    public String getPackageName() {
        return "io.virtdata.libbasics.shared.from_long.to_object";
    }

    @Override
    public String getClassJavadoc() {
        return "This is a higher-order function which takes an input value,\nand flips a coin. The first parameter is used as the threshold\nfor choosing a function. If the sample values derived from the\ninput is lower than the threshold value, then the first following\nfunction is used, and otherwise the second is used.\n\nFor example, if the threshold is 0.23, and the input value is\nhashed and sampled in the unit interval to 0.43, then the second\nof the two provided functions will be used.\n\nThe input value does not need to be hashed beforehand, since the\nuser may need to use the full input value before hashing as the\ninput to one or both of the functions.\n\nThis function will accept either a LongFunction or a {@link Function}\nor a LongUnaryOperator in either position. If necessary, use\n{@link java.util.function.ToLongFunction} to adapt other function forms to be\ncompatible with these signatures.\n";
    }

    @Override
    public String getInType() {
        return "java.lang.Long";
    }

    @Override
    public String getOutType() {
        return "java.lang.Object";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.distributions};
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("CoinFunc", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("threshold", "double");
                        this.put("first", "java.lang.Object");
                        this.put("second", "java.lang.Object");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("CoinFunc(0.15,NumberNameToString(),Combinations('A:1:B:23'))");
                                this.add("use the first function 15% of the time");
                            }
                        });
                    }
                }));
            }
        };
    }
}

