/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_object;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.stathelpers.AliasSamplerDoubleInt;
import io.virtdata.libbasics.core.stathelpers.EvProbD;
import io.virtdata.libbasics.shared.from_long.to_double.HashedDoubleRange;
import io.virtdata.util.VirtDataFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongFunction;

@Categories(value={Category.distributions})
@ThreadSafeMapper
public class WeightedFuncs
implements LongFunction<Object> {
    private final LongFunction<Object>[] funcs;
    private final AliasSamplerDoubleInt functionSampler;
    private HashedDoubleRange unitSampler = new HashedDoubleRange(0.0, 1.0);

    public WeightedFuncs(Object ... objectArray) {
        ArrayList<EvProbD> arrayList = new ArrayList<EvProbD>();
        ArrayList<LongFunction> arrayList2 = new ArrayList<LongFunction>();
        ArrayList arrayList3 = new ArrayList();
        if (objectArray.length % 2 != 0) {
            throw new RuntimeException("You must have weights and functions, pairwise.This is not possible with " + Arrays.toString(objectArray));
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            double d = 1.0;
            try {
                d = (Double)object;
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("the 0th and ever even value must be a floating point weight.");
            }
            arrayList.add(new EvProbD(i >> 1, d));
            Object object2 = objectArray[i + 1];
            try {
                LongFunction longFunction = VirtDataFunctions.adapt(object2, LongFunction.class, Object.class, true);
                arrayList2.add(longFunction);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("There was a problem resolving function " + object2);
            }
        }
        this.funcs = arrayList2.toArray(new LongFunction[0]);
        this.functionSampler = new AliasSamplerDoubleInt(arrayList);
    }

    @Override
    public Object apply(long l) {
        double d = this.unitSampler.applyAsDouble(l);
        int n = this.functionSampler.applyAsInt(d);
        LongFunction<Object> longFunction = this.funcs[n];
        Object object = longFunction.apply(l);
        return object;
    }
}

