/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_int.HashRange;
import io.virtdata.util.VirtDataResources;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class HashedLineToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(HashedLineToString.class);
    private final HashRange indexRange;
    private List<String> lines = new ArrayList<String>();
    private final String filename;

    public HashedLineToString(String string) {
        this.filename = string;
        this.lines = VirtDataResources.readDataFileLines(string);
        this.indexRange = new HashRange(0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public String apply(long l) {
        int n = this.indexRange.applyAsInt(l);
        String string = this.lines.get(n);
        return string;
    }
}

