/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
public class ListTemplate
implements LongFunction<List<String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<String> valueFunc;

    @Example(value={"ListTemplate(HashRange(3,7),NumberNameToString())", "create a list between 3 and 7 elements, with number names as the values"})
    public ListTemplate(LongToIntFunction longToIntFunction, LongFunction<String> longFunction) {
        this.sizeFunc = longToIntFunction;
        this.valueFunc = longFunction;
    }

    @Override
    public List<String> apply(long l) {
        int n = this.sizeFunc.applyAsInt(l);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.valueFunc.apply(l + (long)i));
        }
        return arrayList;
    }
}

