/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types.joda;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_time_types.joda.Timezones;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfNamedWeekDay
implements LongUnaryOperator {
    private final DateTimeZone tz;
    private final int weekdayReference;

    @Example(value={"ToMillisAtStartOfNamedWeekDay()", "return millisecond epoch time of the start of the most recent Monday (possibly the day-of) of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfNamedWeekDay() {
        this("Monday");
    }

    @Example(value={"ToMillisAtStartOfNamedWeekDay('Wednesday')", "return millisecond epoch time of the start of the most recent Wednesday (possibly the day-of) of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfNamedWeekDay(String string) {
        this(string, DateTimeZone.UTC.getID());
    }

    @Example(value={"ToMillisAtStartOfNamedWeekDay('Saturday','America/Chicago'')", "return millisecond epoch time of the start of the most recent Saturday (possibly the day-of) of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfNamedWeekDay(String string, String string2) {
        this.weekdayReference = WeekDays.valueOfOrdinal(string);
        this.tz = Timezones.forId(string2);
    }

    @Override
    public long applyAsLong(long l) {
        DateTime dateTime = new DateTime(l, this.tz).withTimeAtStartOfDay();
        DateTime dateTime2 = dateTime.withDayOfWeek(this.weekdayReference);
        return dateTime2.isBefore(dateTime) ? dateTime2.getMillis() : dateTime2.plusDays(7).getMillis();
    }

    private static enum WeekDays {
        Monday(1),
        Tuesday(2),
        Wednesday(3),
        Thursday(4),
        Friday(5),
        Saturday(6),
        Sunday(7);

        private final int ordinal;

        private WeekDays(int n2) {
            this.ordinal = n2;
        }

        public static int valueOfOrdinal(String string) {
            for (WeekDays weekDays : WeekDays.values()) {
                if (!weekDays.toString().toLowerCase().equals(string.toLowerCase())) continue;
                return weekDays.ordinal;
            }
            throw new RuntimeException("Unable to map weekday name " + string + " to values: " + Arrays.toString((Object[])WeekDays.values()));
        }
    }
}

