/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadInteger
implements Function<Object, Integer> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final int defaultValue;

    @Example(value={"LoadInteger('foo')", "for the current thread, load an integer value from the named variable."})
    public LoadInteger(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger('foo',42)", "for the current thread, load an integer value from the named variable, or the default value if the named variable is not defined."})
    public LoadInteger(String string, int n) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = n;
    }

    @Example(value={"LoadInteger(NumberNameToString())", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function."})
    public LoadInteger(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger(NumberNameToString(),42)", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadInteger(Function<Object, Object> function, int n) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = n;
    }

    @Override
    public Integer apply(Object object) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        Object object2 = hashMap.getOrDefault(string, this.defaultValue);
        return (Integer)object2;
    }
}

