/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadString
implements Function<Object, String> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final String defaultValue;

    @Example(value={"LoadString('foo','examplevalue')", "for the current thread, load a String value from the named variable."})
    public LoadString(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = "";
    }

    @Example(value={"LoadString('foo','examplevalue')", "for the current thread, load a String value from the named variable, or the default value if the named variable is not defined."})
    public LoadString(String string, String string2) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = string2;
    }

    @Example(value={"LoadString(NumberNameToString(),'examplevalue')", "for the current thread, load a String value from the named variable, or the default value if the named variable is not defined."})
    public LoadString(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = "";
    }

    @Example(value={"LoadString(NumberNameToString(),'examplevalue')", "for the current thread, load a String value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadString(Function<Object, Object> function, String string) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = string;
    }

    @Override
    public String apply(Object object) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object2 = hashMap.getOrDefault(string, this.defaultValue);
        return (String)object2;
    }
}

