/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveDouble
implements DoubleUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"Save('foo')", "save the current double value to the name 'foo' in this thread"})
    public SaveDouble(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"Save(NumberNameToString())", "save a double value to a named variable in the current thread, where the variable name is provided by a function."})
    public SaveDouble(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public double applyAsDouble(double d) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(d)) : this.name;
        hashMap.put(string, d);
        return d;
    }
}

