/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveFloat
implements UnaryOperator<Float> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveFloat('foo')", "save the current float value to a named variable in this thread."})
    public SaveFloat(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"SaveFloat(NumberNameToString())", "save the current float value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveFloat(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public Float apply(Float f) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(f)) : this.name;
        hashMap.put(string, f);
        return f;
    }
}

