/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveLong
implements LongUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveLong('foo')", "save the current long value to a named variable in this thread."})
    public SaveLong(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"SaveLong(NumberNameToString())", "save the current long value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveLong(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public long applyAsLong(long l) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        SharedState.tl_ObjectMap.get().put(string, l);
        return l;
    }
}

