/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.state, Category.diagnostics})
public class Show
implements LongFunction<String> {
    private final String[] names;
    private final ThreadLocal<StringBuilder> tl_sb = ThreadLocal.withInitial(StringBuilder::new);

    @Example(value={"Show()", "Show all values in a json-like format"})
    public Show() {
        this.names = null;
    }

    @Examples(value={@Example(value={"Show('foo')", "Show only the 'foo' value in a json-like format"}), @Example(value={"Show('foo','bar')", "Show the 'foo' and 'bar' values in a json-like format"})})
    public Show(String ... stringArray) {
        this.names = stringArray;
    }

    @Override
    public String apply(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        if (this.names == null) {
            return hashMap.toString();
        }
        StringBuilder stringBuilder = this.tl_sb.get();
        stringBuilder.setLength(0);
        stringBuilder.append("{");
        for (String string : this.names) {
            stringBuilder.append(string).append("=");
            Object object = hashMap.get(string);
            stringBuilder.append(object == null ? "NULL" : object.toString());
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

