/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Save
implements IntUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"Save('foo')", "save the current int value to the name 'foo' in this thread"})
    public Save(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"Save(NumberNameToString())", "save the current int value to a named variable in this thread,where the variable name is provided by a function."})
    public Save(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public int applyAsInt(int n) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(n)) : this.name;
        SharedState.tl_ObjectMap.get().put(string, n);
        return n;
    }
}

