/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_string;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Load
implements Function<String, String> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final String defaultValue;

    @Example(value={"Load('foo')", "for the current thread, load a String value from the named variable"})
    public Load(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = null;
    }

    @Example(value={"Load('foo','track05')", "for the current thread, load a String value from the named variable, or teh default value if the variable is not yet defined."})
    public Load(String string, String string2) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = string2;
    }

    @Example(value={"Load(NumberNameToString())", "for the current thread, load a String value from the named variable, where the variable name is provided by a function"})
    public Load(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = null;
    }

    @Example(value={"Load(NumberNameToString(),'track05')", "for the current thread, load a String value from the named variable, where the variable name is provided by a function, or the default value if the variable is not yet defined."})
    public Load(Function<Object, Object> function, String string) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = string;
    }

    @Override
    public String apply(String string) {
        String string2 = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(string)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object = hashMap.getOrDefault(string2, this.defaultValue);
        return (String)object;
    }
}

