/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_string;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;

@Categories(value={Category.conversion})
@ThreadSafeMapper
public class ToBase64String
implements Function<String, String> {
    private static final ThreadLocal<TLState> tl_state = ThreadLocal.withInitial(() -> new TLState());

    @Example(value={"ToBase64String()", "encode any input as Base64"})
    public ToBase64String() {
    }

    @Override
    public String apply(String string) {
        TLState tLState = tl_state.get();
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes(StandardCharsets.UTF_8));
        return tLState.encoder.encodeToString(byteBuffer.array());
    }

    private static class TLState {
        public Base64.Encoder encoder = Base64.getEncoder();

        private TLState() {
        }
    }
}

