/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.templates.BindPoint;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedTemplate {
    private static final Pattern[] DEFAULT_PATTERNS = new Pattern[]{Pattern.compile("\\{(?<anchor>\\w+[-_\\d\\w.]*)}"), Pattern.compile("\\?(?<anchor>\\w+[-_\\d\\w.]*)")};
    private static final Logger logger = LoggerFactory.getLogger(ParsedTemplate.class);
    private final Pattern[] patterns;
    private final String rawtemplate;
    private final String[] spans;
    private final Set<String> missingBindings = new HashSet<String>();
    private final Set<String> extraBindings = new HashSet<String>();
    private final Map<String, String> bindings = new LinkedHashMap<String, String>();
    private final Map<String, String> specificBindings = new LinkedHashMap<String, String>();

    public ParsedTemplate(String string, Map<String, String> map) {
        this(string, map, DEFAULT_PATTERNS);
    }

    public ParsedTemplate(String string, Map<String, String> map, Pattern ... patternArray) {
        this.rawtemplate = string;
        this.bindings.putAll(map);
        this.patterns = patternArray;
        this.spans = this.parse();
    }

    public ParsedTemplate orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this.toString());
        }
        return this;
    }

    private String[] parse() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        this.extraBindings.addAll(this.bindings.keySet());
        String string = this.rawtemplate;
        boolean bl = false;
        int n = 0;
        for (Pattern pattern : this.patterns) {
            if (!pattern.toString().contains("?<anchor>")) {
                throw new InvalidParameterException("The provided pattern '" + pattern.toString() + "' must contain a named group called anchor,as in '(?<anchor>...)'");
            }
            Matcher matcher = pattern.matcher(this.rawtemplate);
            if (!matcher.find()) continue;
            while (matcher.find(n)) {
                String string2 = string.substring(n, matcher.start());
                arrayList.add(string2);
                String string3 = matcher.group("anchor");
                n = matcher.end();
                arrayList.add(string3);
                if (this.extraBindings.contains(string3)) {
                    hashSet.add(string3);
                    this.specificBindings.put(string3, this.bindings.get(string3));
                    continue;
                }
                this.missingBindings.add(string3);
            }
            hashSet.forEach(this.extraBindings::remove);
            break;
        }
        if (n >= 0) {
            arrayList.add(string.substring(n));
        } else {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("template: '").append(this.rawtemplate).append("'");
        stringBuilder.append("\n parsed: ");
        stringBuilder.append(StreamSupport.stream(Arrays.spliterator(this.spans), false).map(string -> "[" + string + "]").collect(Collectors.joining(",")));
        stringBuilder.append("\n missing bindings: ").append(this.missingBindings.stream().collect(Collectors.joining(",", "[", "]")));
        stringBuilder.append(" extra bindings: ");
        stringBuilder.append("\n extra bindings: ").append(this.extraBindings.stream().collect(Collectors.joining(",", "[", "]")));
        return stringBuilder.toString();
    }

    public boolean hasError() {
        return this.missingBindings.size() > 0;
    }

    public Set<String> getExtraBindings() {
        return this.extraBindings;
    }

    public Set<String> getMissingBindings() {
        return this.missingBindings;
    }

    public Map<String, String> getSpecificBindings() {
        return this.specificBindings;
    }

    public List<String> getAnchors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < this.spans.length; i += 2) {
            arrayList.add(this.spans[i]);
        }
        return arrayList;
    }

    public List<BindPoint> getBindPoints() {
        ArrayList<BindPoint> arrayList = new ArrayList<BindPoint>();
        for (int i = 1; i < this.spans.length; i += 2) {
            if (!this.bindings.containsKey(this.spans[i])) {
                throw new InvalidParameterException("Binding named '" + this.spans[i] + "' is not provided for template '" + this.rawtemplate + "'");
            }
            arrayList.add(new BindPoint(this.spans[i], this.bindings.get(this.spans[i])));
        }
        return arrayList;
    }

    public String getPositionalStatement(Function<String, String> function) {
        StringBuilder stringBuilder = new StringBuilder(this.spans[0]);
        for (int i = 1; i < this.spans.length; i += 2) {
            stringBuilder.append(function.apply(this.spans[i]));
            stringBuilder.append(this.spans[i + 1]);
        }
        return stringBuilder.toString();
    }

    public String[] getSpans() {
        return this.spans;
    }
}

