/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_12)
public class ServiceProcessor
extends AbstractProcessor {
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private Map<String, Writer> writers = new HashMap<String, Writer>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("io.virtdata.annotations.Service");
        return hashSet;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.options = processingEnvironment.getOptions();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.messenger = processingEnvironment.getMessager();
        this.sourceVersion = processingEnvironment.getSourceVersion();
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    private Writer getWriterForClass(String string2, Element ... elementArray) {
        return this.writers.computeIfAbsent(string2, string -> {
            try {
                return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + string, elementArray).openWriter();
            }
            catch (IOException iOException) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, iOException.toString());
                return null;
            }
        });
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        ArrayList arrayList = new ArrayList();
        try {
            for (String object : this.getSupportedAnnotationTypes()) {
                Class<?> clazz = Class.forName(object);
                Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(clazz);
                for (Element element : set2) {
                    String string = null;
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        DeclaredType declaredType = annotationMirror.getAnnotationType();
                        if (!object.equals(declaredType.toString())) continue;
                        List list = annotationMirror.getElementValues().keySet().stream().filter(executableElement -> executableElement.toString().equals("value()")).collect(Collectors.toList());
                        if (list.size() == 0) {
                            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Annotation missing required value");
                            return false;
                        }
                        AnnotationValue annotationValue = annotationMirror.getElementValues().get(list.get(0));
                        string = annotationValue.getValue().toString();
                    }
                    Writer writer = this.getWriterForClass(string, set2.toArray(new Element[0]));
                    Name name = ((TypeElement)element).getQualifiedName();
                    this.messenger.printMessage(Diagnostic.Kind.NOTE, "Adding service entry for implementation of " + string + ": " + name);
                    writer.write(name + "\n");
                }
            }
            for (Writer writer : this.writers.values()) {
                writer.close();
            }
        }
        catch (Exception exception) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, exception.toString());
        }
        return true;
    }
}

