/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.api.ApiType;
import io.virtualan.core.VirtualServiceInfo;
import io.virtualan.core.model.ResourceMapper;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="openApiVirtualServiceInfo")
public class OpenApiVirtualServiceInfo
implements VirtualServiceInfo {
    private static final Logger log = LoggerFactory.getLogger(OpenApiVirtualServiceInfo.class);
    @Autowired
    private ObjectMapper objectMapper;
    ResourceMapper resourceParent;
    Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice;
    @Autowired
    private ApiType apiType;

    @Override
    public ApiType getApiType() {
        return this.apiType;
    }

    @Override
    public void setApiType(ApiType apiType) {
        this.apiType = apiType;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public ResourceMapper getResourceParent() {
        return this.resourceParent;
    }

    @Override
    public void setResourceParent(ResourceMapper resourceParent) {
        this.resourceParent = resourceParent;
    }

    @Override
    public Map<String, Map<String, VirtualServiceRequest>> getMockLoadChoice() {
        return this.mockLoadChoice;
    }

    @Override
    public void setMockLoadChoice(Map<String, Map<String, VirtualServiceRequest>> mockLoadChoice) {
        this.mockLoadChoice = mockLoadChoice;
    }

    @Override
    public VirtualServiceRequest buildServiceDetails(boolean scriptEnabled, Map.Entry<String, Class> virtualServiceEntry, Method method) throws JsonProcessingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        RequestMapping[] annotInstance = (RequestMapping[])method.getAnnotationsByType(RequestMapping.class);
        VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
        virtualServiceRequest.setDesc(this.getResourceDesc(method));
        if (annotInstance != null && annotInstance.length > 0) {
            RequestMapping requestMapping = annotInstance[0];
            if (requestMapping.value().length > 0) {
                int index;
                virtualServiceRequest.setUrl(requestMapping.value()[0]);
                int n = index = virtualServiceRequest.getUrl().indexOf(47, 1) == -1 ? virtualServiceRequest.getUrl().length() : virtualServiceRequest.getUrl().indexOf(47, 1);
                if (virtualServiceRequest.getResource() == null) {
                    virtualServiceRequest.setResource(virtualServiceRequest.getUrl().substring(1, index));
                }
            }
            if (requestMapping.method().length > 0) {
                virtualServiceRequest.setMethod(requestMapping.method()[0].name());
            }
            virtualServiceRequest.setResponseType(this.buildResponseType(method));
            this.buildInput(method, virtualServiceRequest);
            virtualServiceRequest.setOperationId(method.getName());
            virtualServiceRequest.setHttpStatusMap(this.getHttpStatusMap());
            virtualServiceRequest.setTypes(this.getTypes(scriptEnabled));
            return virtualServiceRequest;
        }
        return null;
    }

    @Override
    public void buildInput(Method method, VirtualServiceRequest mockLoadRequest) throws ClassNotFoundException {
        int i = 0;
        ArrayList<VirtualServiceKeyValue> availableParams = new ArrayList<VirtualServiceKeyValue>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation[] anns : annotations) {
            Class<?> parameterType = parameterTypes[i++];
            for (Annotation paramAnnotation : anns) {
                if (paramAnnotation.annotationType().equals(RequestParam.class)) {
                    RequestParam requestParam = (RequestParam)paramAnnotation;
                    availableParams.add(new VirtualServiceKeyValue(requestParam.value(), "QUERY_PARAM"));
                    continue;
                }
                if (paramAnnotation.annotationType().equals(PathVariable.class)) {
                    PathVariable pathVariable = (PathVariable)paramAnnotation;
                    availableParams.add(new VirtualServiceKeyValue(pathVariable.value(), "PATH_PARAM"));
                    continue;
                }
                if (!paramAnnotation.annotationType().equals(org.springframework.web.bind.annotation.RequestBody.class)) continue;
                RequestBody requestBody = new RequestBody();
                requestBody.setInputObjectTypeName(Class.forName(parameterType.getName()).getTypeName());
                requestBody.setInputObjectType(parameterType);
                requestBody.setObjectMapper(this.objectMapper);
                mockLoadRequest.setInputObjectType(Class.forName(parameterType.getName()));
                try {
                    mockLoadRequest.setInput(RequestBodyTypes.fromString(requestBody.getInputObjectTypeName()).getDefaultMessageBody(requestBody));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        mockLoadRequest.setAvailableParams(availableParams);
    }

    @Override
    public Map<String, VirtualServiceApiResponse> buildResponseType(Method method) {
        return this.buildOpenAPIResponseType(method);
    }
}

