/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.VirtualServiceKeyValue;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.service.VirtualService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@EnableScheduling
@Configuration
public class MockDataBatchProcess
implements SchedulingConfigurer {
    private final Logger log = LoggerFactory.getLogger(MockDataBatchProcess.class);
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Autowired
    private VirtualService virtualService;
    @Value(value="${virtualan.task.pool.size:5}")
    private int poolSize;
    @Value(value="${virtualan.data.load:not-set}")
    private String dataLoadFileLocation;
    @Value(value="${virtualan.remove.unused-data.after:30}")
    private int removeMockDataUnusedAfter;
    @Value(value="${virtualan.do.cleanup:false}")
    private boolean doCleanup;

    @PostConstruct
    public void loadRequestdata() {
        try {
            InputStream stream = MockDataBatchProcess.class.getClassLoader().getResourceAsStream(this.dataLoadFileLocation);
            if (stream != null) {
                String respData = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                JSONTokener parser = new JSONTokener(respData);
                LinkedList<VirtualServiceRequest> requestList = new LinkedList<VirtualServiceRequest>();
                JSONArray arrayList = (JSONArray)parser.nextValue();
                for (int i = 0; i < arrayList.length(); ++i) {
                    VirtualServiceRequest request = this.createRequest((JSONObject)arrayList.get(i));
                    if (request.getOperationId() != null) {
                        requestList.add(request);
                        continue;
                    }
                    this.log.warn("This API({} : {}) is not supported by this service any more: {}", new Object[]{request.getMethod(), request.getUrl(), request});
                }
                this.virtualService.importAllMockRequests(requestList);
                this.log.info("initial load of the file ({}) successful!!", (Object)this.dataLoadFileLocation);
            } else {
                this.log.warn("initial load of the file ({}) is missing...", (Object)this.dataLoadFileLocation);
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to load the file ({}) initial load -{}", (Object)this.dataLoadFileLocation, (Object)e.getMessage());
        }
    }

    private String hasValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    private VirtualServiceRequest createRequest(JSONObject jsonObject) {
        VirtualServiceRequest virtualServiceRequest = new VirtualServiceRequest();
        try {
            virtualServiceRequest.setResource(this.hasValue(jsonObject.optString("resource")));
            virtualServiceRequest.setInput(this.hasValue(jsonObject.optString("input")));
            virtualServiceRequest.setOutput(this.hasValue(jsonObject.optString("output")));
            virtualServiceRequest.setHttpStatusCode(this.hasValue(jsonObject.optString("httpStatusCode")));
            if (!"".equalsIgnoreCase(jsonObject.optString("method"))) {
                virtualServiceRequest.setMethod(this.hasValue(jsonObject.optString("method")));
            } else if (!"".equalsIgnoreCase(jsonObject.optString("responseTopicOrQueueName"))) {
                virtualServiceRequest.setMethod(this.hasValue(jsonObject.optString("responseTopicOrQueueName")));
            }
            virtualServiceRequest.setType(this.hasValue(jsonObject.optString("type")));
            virtualServiceRequest.setRequestType(this.hasValue(jsonObject.optString("requestType")));
            if (!jsonObject.optString("contentType").equals("")) {
                virtualServiceRequest.setContentType(ContentType.valueOf(jsonObject.optString("contentType")));
            }
            virtualServiceRequest.setRule(this.hasValue(jsonObject.optString("rule")));
            if (!"".equalsIgnoreCase(jsonObject.optString("url")) || !"".equalsIgnoreCase(jsonObject.optString("brokerUrl"))) {
                if (!"".equalsIgnoreCase(jsonObject.optString("url"))) {
                    virtualServiceRequest.setUrl(jsonObject.optString("url"));
                } else if (!"".equalsIgnoreCase(jsonObject.optString("brokerUrl"))) {
                    virtualServiceRequest.setUrl(jsonObject.optString("brokerUrl"));
                }
            }
            virtualServiceRequest.setAvailableParams(this.getParams(jsonObject.optJSONArray("availableParams")));
            virtualServiceRequest.setHeaderParams(this.getParams(jsonObject.optJSONArray("headerParams")));
            virtualServiceRequest.setExcludeList(this.hasValue(jsonObject.optString("excludeList")));
            if (!"".equalsIgnoreCase(jsonObject.optString("requestTopicOrQueueName"))) {
                virtualServiceRequest.setOperationId(this.hasValue(jsonObject.optString("requestTopicOrQueueName")));
            } else if (jsonObject.optString("operationId").equals("")) {
                this.virtualServiceUtil.findOperationIdForService(virtualServiceRequest);
            } else {
                virtualServiceRequest.setOperationId(this.hasValue(jsonObject.optString("operationId")));
            }
        }
        catch (Exception e) {
            this.log.info(" unable to load the following data ({}) : Failed due to ::{} ", (Object)jsonObject, (Object)e.getMessage());
        }
        return virtualServiceRequest;
    }

    private List<VirtualServiceKeyValue> getParams(JSONArray params) {
        LinkedList<VirtualServiceKeyValue> virtualServiceKeyValueList = new LinkedList<VirtualServiceKeyValue>();
        if (params != null && params.length() > 0) {
            for (int i = 0; i < params.length(); ++i) {
                try {
                    JSONObject object = params.getJSONObject(i);
                    VirtualServiceKeyValue virtualServiceKeyValue = new VirtualServiceKeyValue();
                    virtualServiceKeyValue.setKey(object.optString("key"));
                    virtualServiceKeyValue.setValue(object.optString("value"));
                    virtualServiceKeyValue.setParameterType(object.optString("parameterType"));
                    virtualServiceKeyValueList.add(virtualServiceKeyValue);
                    continue;
                }
                catch (JSONException e) {
                    this.log.warn("Loader: {}", (Object)e.getMessage());
                }
            }
        }
        return virtualServiceKeyValueList;
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.poolSize);
        threadPoolTaskScheduler.setThreadNamePrefix("vCleanup-");
        threadPoolTaskScheduler.initialize();
        scheduledTaskRegistrar.setTaskScheduler((TaskScheduler)threadPoolTaskScheduler);
    }

    @Scheduled(cron="${virtualan.cron.expression:0 0 0 * * ?}")
    public void scheduleTaskCleanUnused() {
        this.virtualService.periodicalRemovalOfUnusedMocks(this.removeMockDataUnusedAfter, this.doCleanup);
    }
}

