/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.core.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.ContentType;
import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.MockResponse;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.model.ResponseProcessType;
import io.virtualan.core.model.VirtualServiceApiResponse;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.ReturnMockResponse;
import io.virtualan.core.util.ScriptErrorException;
import io.virtualan.core.util.VirtualServiceParamComparator;
import io.virtualan.core.util.XMLConverter;
import io.virtualan.core.util.rule.RuleEvaluator;
import io.virtualan.core.util.rule.ScriptExecutor;
import io.virtualan.mapson.Mapson;
import io.virtualan.requestbody.RequestBody;
import io.virtualan.requestbody.RequestBodyTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="virtualServiceValidRequest")
public class VirtualServiceValidRequest {
    private static final Logger log = LoggerFactory.getLogger(VirtualServiceValidRequest.class);
    @Autowired
    private RuleEvaluator ruleEvaluator;
    @Autowired
    private VirtualServiceUtil virtualServiceUtil;
    @Autowired
    private ScriptExecutor scriptExecutor;
    @Autowired
    private VirtualServiceParamComparator virtualServiceParamComparator;
    @Autowired
    private ObjectMapper objectMapper;

    private ObjectMapper getObjectMapper() {
        this.objectMapper.findAndRegisterModules();
        return this.objectMapper.enable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public boolean validResponse(VirtualServiceRequest mockTransferObjectActual, VirtualServiceRequest mockTransferObject) throws ClassNotFoundException, IOException {
        VirtualServiceApiResponse apiResponse = mockTransferObjectActual.getResponseType().get(mockTransferObject.getHttpStatusCode());
        if (apiResponse != null && apiResponse.getObjectType() != null && mockTransferObject.getOutput() != null) {
            this.objectMapper.readValue(mockTransferObject.getOutput().toString(), Class.forName(apiResponse.getObjectType()));
        }
        return true;
    }

    public final Map<Integer, ReturnMockResponse> validForParam(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (ResponseProcessType.PARAMS.name().equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            if (numberAttrMatch == 0) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            log.debug("{} : {}", (Object)numberAttrMatch, (Object)mockRequestResponse.getKey().getAvailableParams().size());
            returnMockResponse.setExactMatch(numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size());
            matchMap.put(++count, returnMockResponse);
        }
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> validBusinessRuleForInputObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (!"RULE".equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            log.debug("Rule key : {}", (Object)mockRequestResponse.getKey().getRule());
            log.debug("Rule Input : {}", (Object)mockServiceRequest);
            log.debug("Rule evaluated flag : {}", (Object)this.ruleEvaluator.expressionEvaluator(mockServiceRequest, mockRequestResponse.getKey().getRule()));
            if (!this.ruleEvaluator.expressionEvaluator(mockServiceRequest, mockRequestResponse.getKey().getRule())) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
            log.debug("Successful expression Rule evaluated : ");
            returnMockResponse.setExactMatch(true);
            matchMap.put(count, returnMockResponse);
        }
        log.debug("Rule evaluated Ended : {}", matchMap);
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> checkScriptResponse(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, ScriptErrorException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (!ResponseProcessType.SCRIPT.name().equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            log.debug("Script : {}", (Object)mockRequestResponse.getKey().getRule());
            log.debug("Script Input {}: ", (Object)mockServiceRequest);
            try {
                MockResponse mockResponse = new MockResponse();
                mockResponse = this.scriptExecutor.executeScript(mockServiceRequest, mockResponse, mockRequestResponse.getKey().getRule());
                log.debug("Script output expected : {}", (Object)mockResponse);
                if (mockResponse != null) {
                    ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
                    returnMockResponse.setMockResponse(mockResponse);
                    log.debug("Successful expression Rule evaluated : ");
                    returnMockResponse.setExactMatch(true);
                    matchMap.put(count, returnMockResponse);
                }
            }
            catch (Exception e) {
                log.warn("Oh!!! check the groovy script... Script was not working as expected configuration? " + e.getMessage());
                throw new ScriptErrorException("Oh!!! check the groovy script... Script was not working as expected configuration? " + e.getMessage());
            }
            return matchMap;
        }
        log.debug("Rule evaluated Ended : " + matchMap);
        return matchMap;
    }

    public Map<Integer, ReturnMockResponse> validObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        if (ContentType.XML.equals((Object)mockServiceRequest.getContentType())) {
            return this.virtualServiceUtil.isResponseExists(mockDataSetupMap, mockServiceRequest);
        }
        String jsonString = mockServiceRequest.getInputObjectType() != null && mockServiceRequest.getInputObjectType().equals(mockServiceRequest.getInput().getClass()) ? this.getObjectMapper().writeValueAsString(mockServiceRequest.getInput()) : mockServiceRequest.getInput().toString();
        Map actualMap = Mapson.buildMAPsonFromJson((String)jsonString);
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            Map expectedMap;
            this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            String expectedJSON = null;
            if (ContentType.XML.equals((Object)mockRequestResponse.getKey().getContentType())) {
                Object object = XMLConverter.xmlToObject(mockServiceRequest.getInputObjectType(), mockRequestResponse.getKey().getInput());
                expectedJSON = this.getObjectMapper().writeValueAsString(object);
            } else {
                expectedJSON = mockRequestResponse.getKey().getInput();
            }
            if (!this.areEqual(actualMap, expectedMap = Mapson.buildMAPsonFromJson((String)expectedJSON))) continue;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            boolean isMatched = this.virtualServiceParamComparator.isAllParamPresent(mockServiceRequest, returnMockResponse);
            returnMockResponse.setExactMatch(isMatched);
            matchMap.put(++count, returnMockResponse);
        }
        return matchMap;
    }

    private boolean areEqual(Map<String, String> first, Map<String, String> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return first.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(second.get(e.getKey())));
    }

    public Map<Integer, ReturnMockResponse> validForInputObject(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
            if ((ResponseProcessType.RULE.name().equalsIgnoreCase(mockServiceRequest.getType()) || ResponseProcessType.SCRIPT.name().equalsIgnoreCase(mockServiceRequest.getType()) || ResponseProcessType.SCRIPT.name().equalsIgnoreCase(mockRequestResponse.getKey().getType()) || ResponseProcessType.RULE.name().equalsIgnoreCase(mockRequestResponse.getKey().getType())) && mockServiceRequest.getRule() != null && mockServiceRequest.getRule().equals(mockRequestResponse.getKey().getRule())) {
                return this.getScriptResponseCount(mockServiceRequest, matchMap, ++count, mockRequestResponse, numberAttrMatch);
            }
            if (!ResponseProcessType.RESPONSE.name().equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            count = this.getResponseCount(mockServiceRequest, matchMap, count, mockRequestResponse, numberAttrMatch);
        }
        return matchMap;
    }

    public int getResponseCount(MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> matchMap, int count, Map.Entry<MockRequest, MockResponse> mockRequestResponse, int numberAttrMatch) throws IOException, JAXBException {
        RequestBody requestBody = this.buildRequestBody(mockServiceRequest, mockRequestResponse);
        if (numberAttrMatch != 0 && RequestBodyTypes.fromString(mockServiceRequest.getInputObjectType().getTypeName()).compareRequestBody(requestBody)) {
            this.getResponseCount(mockServiceRequest, matchMap, ++count, mockRequestResponse, numberAttrMatch, requestBody);
        }
        return count;
    }

    public Map<Integer, ReturnMockResponse> getScriptResponseCount(MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> matchMap, int count, Map.Entry<MockRequest, MockResponse> mockRequestResponse, int numberAttrMatch) {
        ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
        returnMockResponse.setExactMatch(true);
        matchMap.put(count, returnMockResponse);
        return matchMap;
    }

    public void getResponseCount(MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> matchMap, int count, Map.Entry<MockRequest, MockResponse> mockRequestResponse, int numberAttrMatch, RequestBody requestBody) throws IOException, JAXBException {
        ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
        returnMockResponse.setExactMatch(mockRequestResponse.getKey().getAvailableParams().isEmpty() ? mockRequestResponse.getKey().getAvailableParams().isEmpty() : numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size() && RequestBodyTypes.fromString(mockServiceRequest.getInputObjectType().getTypeName()).compareRequestBody(requestBody));
        matchMap.put(count, returnMockResponse);
    }

    public Map<Integer, ReturnMockResponse> validForNoParam(Map<MockRequest, MockResponse> mockDataSetupMap, MockServiceRequest mockServiceRequest) throws IOException, JAXBException {
        HashMap<Integer, ReturnMockResponse> matchMap = new HashMap<Integer, ReturnMockResponse>();
        int count = 0;
        for (Map.Entry<MockRequest, MockResponse> mockRequestResponse : mockDataSetupMap.entrySet()) {
            if (ResponseProcessType.PARAMS.name().equalsIgnoreCase(mockRequestResponse.getKey().getType())) continue;
            RequestBody requestBody = this.buildRequestBody(mockServiceRequest, mockRequestResponse);
            if (RequestBodyTypes.fromString("NO_REQUEST_PARAM").compareRequestBody(requestBody) && (mockServiceRequest.getParams() == null || mockServiceRequest.getParams().isEmpty())) {
                count = this.getNoParamMatch(mockServiceRequest, matchMap, count, mockRequestResponse);
                continue;
            }
            count = this.getMatch(mockServiceRequest, matchMap, count, mockRequestResponse);
        }
        return matchMap;
    }

    public int getNoParamMatch(MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> matchMap, int count, Map.Entry<MockRequest, MockResponse> mockRequestResponse) {
        if (mockRequestResponse.getKey().getAvailableParams().isEmpty()) {
            boolean numberAttrMatch = true;
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, 1);
            returnMockResponse.setExactMatch(true);
            matchMap.put(++count, returnMockResponse);
        }
        return count;
    }

    public int getMatch(MockServiceRequest mockServiceRequest, Map<Integer, ReturnMockResponse> matchMap, int count, Map.Entry<MockRequest, MockResponse> mockRequestResponse) {
        int numberAttrMatch = this.virtualServiceParamComparator.compareQueryParams(mockRequestResponse.getKey(), mockServiceRequest);
        if (numberAttrMatch != 0) {
            ReturnMockResponse returnMockResponse = this.returnMockResponse(mockServiceRequest, mockRequestResponse, numberAttrMatch);
            returnMockResponse.setExactMatch(numberAttrMatch == mockRequestResponse.getKey().getAvailableParams().size());
            matchMap.put(++count, returnMockResponse);
        }
        return count;
    }

    private RequestBody buildRequestBody(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> mockRequestResponse) {
        RequestBody requestBody = new RequestBody();
        requestBody.setObjectMapper(this.getObjectMapper());
        requestBody.setExcludeList(mockRequestResponse.getKey().getExcludeSet());
        requestBody.setExpectedInput(mockRequestResponse.getKey().getInput());
        requestBody.setInputObjectType(mockServiceRequest.getInputObjectType());
        requestBody.setActualInput(mockServiceRequest.getInput());
        requestBody.setContentType(mockRequestResponse.getKey().getContentType());
        return requestBody;
    }

    public ReturnMockResponse returnMockResponse(MockServiceRequest mockServiceRequest, Map.Entry<MockRequest, MockResponse> mockRequestResponse, int numberAttrMatch) {
        ReturnMockResponse returnMockResponse = new ReturnMockResponse();
        returnMockResponse.setMockResponse(mockRequestResponse.getValue());
        returnMockResponse.setHeaderResponse(mockServiceRequest.getHeaderParams());
        returnMockResponse.setMockRequest(mockRequestResponse.getKey());
        returnMockResponse.setNumberAttrMatch(numberAttrMatch);
        return returnMockResponse;
    }
}

