/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.service;

import io.virtualan.core.model.MockRequest;
import io.virtualan.core.model.VirtualServiceRequest;
import io.virtualan.core.util.Converter;
import io.virtualan.dao.VirtualServiceRepository;
import io.virtualan.entity.VirtualServiceEntity;
import io.virtualan.service.VirtualService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="virtualService")
public class VirtualServiceImpl
implements VirtualService {
    private final Logger log = LoggerFactory.getLogger(VirtualServiceImpl.class);
    @Autowired
    @Qualifier(value="virtualServiceRepository")
    private VirtualServiceRepository virtualServiceRepository;
    @Autowired
    private Converter converter;

    @Override
    public List<VirtualServiceRequest> findAllMockRequests() {
        Iterable mockEntityList = this.virtualServiceRepository.findAll();
        return this.getVirtualServiceRequests(mockEntityList);
    }

    @Override
    public void importAllMockRequests(List<VirtualServiceRequest> virtualServiceRequestList) {
        ArrayList<VirtualServiceEntity> virtualServiceEntityList = new ArrayList<VirtualServiceEntity>();
        for (VirtualServiceRequest request : virtualServiceRequestList) {
            VirtualServiceEntity virtualServiceEntity = Converter.converterRToE(request);
            virtualServiceEntity.setLastUsedDateTime(Calendar.getInstance());
            virtualServiceEntityList.add(virtualServiceEntity);
        }
        this.virtualServiceRepository.saveAll(virtualServiceEntityList);
    }

    @Override
    public VirtualServiceRequest findById(long id) {
        Optional virtualServiceRequest = this.virtualServiceRepository.findById(id);
        return virtualServiceRequest.map(Converter::converterEToR).orElse(null);
    }

    @Override
    @Transactional(value="virtualTransactionManager")
    public VirtualServiceRequest saveMockRequest(VirtualServiceRequest mockTransferObject) {
        VirtualServiceEntity virtualServiceEntity = Converter.converterRToE(mockTransferObject);
        virtualServiceEntity.setLastUsedDateTime(Calendar.getInstance());
        return Converter.converterEToR((VirtualServiceEntity)this.virtualServiceRepository.save(virtualServiceEntity));
    }

    @Override
    public void updateMockRequest(VirtualServiceRequest mockRequest) {
        VirtualServiceEntity virtualServiceEntity = Converter.converterRToE(mockRequest);
        virtualServiceEntity.setLastUsedDateTime(Calendar.getInstance());
        Converter.converterEToR((VirtualServiceEntity)this.virtualServiceRepository.save(virtualServiceEntity));
    }

    @Override
    public void deleteMockRequestById(long id) {
        this.findById(id);
        this.virtualServiceRepository.deleteById(id);
    }

    @Override
    public boolean isMockRequestExist(VirtualServiceRequest mockRequest) {
        return this.virtualServiceRepository.findById(mockRequest.getId()).isPresent();
    }

    public static Predicate<VirtualServiceRequest> filterOperationIdAndResource(String resource, String operationId) {
        return p -> p.getResource().equalsIgnoreCase(resource) && p.getOperationId().equalsIgnoreCase(operationId);
    }

    @Override
    public List<VirtualServiceRequest> readByOperationId(String resource, String operationId) {
        return this.getVirtualServiceRequests(this.virtualServiceRepository.findByResourceAndOperationId(resource, operationId));
    }

    @Override
    @Async(value="asyncWorkExecutor")
    @Transactional(value="virtualTransactionManager")
    public void updateUsageTime(MockRequest request) {
        Optional virtualServiceRequest = this.virtualServiceRepository.findById(request.getVirtualServiceId());
        if (virtualServiceRequest.isPresent()) {
            ((VirtualServiceEntity)virtualServiceRequest.get()).setLastUsedDateTime(Calendar.getInstance());
            long usageCount = request.getUsageCount() + 1L;
            ((VirtualServiceEntity)virtualServiceRequest.get()).setUsageCount(usageCount);
        }
    }

    @Override
    public void periodicalRemovalOfUnusedMocks(int removeMockDataUnusedAfter, boolean doCleanup) {
        if (doCleanup) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -removeMockDataUnusedAfter);
            Iterable<VirtualServiceEntity> mockEntityList = this.virtualServiceRepository.findByLastUsedDateTimeBefore(calendar);
            int count = this.getVirtualServiceRequests(mockEntityList).size();
            if (count > 0) {
                this.virtualServiceRepository.deleteAll(mockEntityList);
            } else {
                this.log.warn("No record to delete...");
            }
        }
    }

    private List<VirtualServiceRequest> getVirtualServiceRequests(Iterable<VirtualServiceEntity> mockEntityList) {
        ArrayList<VirtualServiceRequest> list = new ArrayList<VirtualServiceRequest>();
        for (VirtualServiceEntity mockEntity : mockEntityList) {
            list.add(Converter.converterEToR(mockEntity));
        }
        return list;
    }
}

