/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.ActiveSpanContextSource;
import io.opentracing.contrib.grpc.ActiveSpanSource;
import io.opentracing.contrib.grpc.ClientCloseDecorator;
import io.opentracing.contrib.grpc.ClientSpanDecorator;
import io.opentracing.contrib.grpc.GrpcTags;
import io.opentracing.contrib.grpc.OperationNameConstructor;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ClientTracingInterceptor
implements ClientInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ClientRequestAttribute> tracedAttributes;
    private final ActiveSpanSource activeSpanSource;
    private final ActiveSpanContextSource activeSpanContextSource;
    private final ClientSpanDecorator clientSpanDecorator;
    private final ClientCloseDecorator clientCloseDecorator;

    public ClientTracingInterceptor() {
        this(GlobalTracer.get());
    }

    public ClientTracingInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.operationNameConstructor = OperationNameConstructor.DEFAULT;
        this.streaming = false;
        this.verbose = false;
        this.tracedAttributes = new HashSet<ClientRequestAttribute>();
        this.activeSpanSource = ActiveSpanSource.GRPC_CONTEXT;
        this.activeSpanContextSource = null;
        this.clientSpanDecorator = null;
        this.clientCloseDecorator = null;
    }

    private ClientTracingInterceptor(Tracer tracer, OperationNameConstructor operationNameConstructor, boolean streaming, boolean verbose, Set<ClientRequestAttribute> tracedAttributes, ActiveSpanSource activeSpanSource, ActiveSpanContextSource activeSpanContextSource, ClientSpanDecorator clientSpanDecorator, ClientCloseDecorator clientCloseDecorator) {
        this.tracer = tracer;
        this.operationNameConstructor = operationNameConstructor;
        this.streaming = streaming;
        this.verbose = verbose;
        this.tracedAttributes = tracedAttributes;
        this.activeSpanSource = activeSpanSource;
        this.activeSpanContextSource = activeSpanContextSource;
        this.clientSpanDecorator = clientSpanDecorator;
        this.clientCloseDecorator = clientCloseDecorator;
    }

    public Channel intercept(Channel channel) {
        return ClientInterceptors.intercept(channel, this);
    }

    private SpanContext getActiveSpanContext() {
        Span activeSpan;
        if (this.activeSpanSource != null && (activeSpan = this.activeSpanSource.getActiveSpan()) != null) {
            return activeSpan.context();
        }
        if (this.activeSpanContextSource != null) {
            return this.activeSpanContextSource.getActiveSpanContext();
        }
        return null;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String operationName = this.operationNameConstructor.constructOperationName(method);
        SpanContext activeSpanContext = this.getActiveSpanContext();
        final Span span = this.createSpanFromParent(activeSpanContext, operationName);
        if (this.clientSpanDecorator != null) {
            this.clientSpanDecorator.interceptCall(span, method, callOptions);
        }
        for (ClientRequestAttribute attr : this.tracedAttributes) {
            switch (attr) {
                case ALL_CALL_OPTIONS: {
                    span.setTag(attr.key, callOptions.toString());
                    break;
                }
                case AUTHORITY: {
                    span.setTag(attr.key, String.valueOf(callOptions.getAuthority()));
                    break;
                }
                case COMPRESSOR: {
                    span.setTag(attr.key, String.valueOf(callOptions.getCompressor()));
                    break;
                }
                case DEADLINE: {
                    if (callOptions.getDeadline() == null) {
                        span.setTag(attr.key, "null");
                        break;
                    }
                    span.setTag(attr.key, callOptions.getDeadline().timeRemaining(TimeUnit.MILLISECONDS));
                    break;
                }
                case METHOD_NAME: {
                    span.setTag(attr.key, method.getFullMethodName());
                    break;
                }
                case METHOD_TYPE: {
                    span.setTag(attr.key, String.valueOf((Object)method.getType()));
                    break;
                }
            }
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, final Metadata headers) {
                if (ClientTracingInterceptor.this.verbose) {
                    span.log("Started call");
                }
                if (ClientTracingInterceptor.this.tracedAttributes.contains((Object)ClientRequestAttribute.HEADERS)) {
                    span.setTag(ClientRequestAttribute.HEADERS.key, headers.toString());
                }
                ClientTracingInterceptor.this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, new TextMap(){

                    @Override
                    public void put(String key, String value) {
                        Metadata.Key<String> headerKey = Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER);
                        headers.put(headerKey, value);
                    }

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        throw new UnsupportedOperationException("TextMapInjectAdapter should only be used with Tracer.inject()");
                    }
                });
                ForwardingClientCallListener.SimpleForwardingClientCallListener tracingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        if (ClientTracingInterceptor.this.verbose) {
                            span.log(ImmutableMap.of("Response headers received", headers.toString()));
                        }
                        this.delegate().onHeaders(headers);
                    }

                    @Override
                    public void onMessage(RespT message) {
                        if (ClientTracingInterceptor.this.streaming || ClientTracingInterceptor.this.verbose) {
                            span.log("Response received");
                        }
                        this.delegate().onMessage(message);
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        if (ClientTracingInterceptor.this.verbose) {
                            if (status.getCode().value() == 0) {
                                span.log("Call closed");
                            } else if (status.getDescription() == null) {
                                span.log(ImmutableMap.of("Call failed", "null"));
                            } else {
                                span.log(ImmutableMap.of("Call failed", status.getDescription()));
                            }
                        }
                        GrpcTags.setStatusTags(span, status);
                        if (ClientTracingInterceptor.this.clientCloseDecorator != null) {
                            ClientTracingInterceptor.this.clientCloseDecorator.close(span, status, trailers);
                        }
                        span.finish();
                        this.delegate().onClose(status, trailers);
                    }
                };
                this.delegate().start(tracingResponseListener, headers);
            }

            @Override
            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                String errorMessage = message == null ? "Error" : message;
                if (cause == null) {
                    span.log(errorMessage);
                } else {
                    span.log(ImmutableMap.of(errorMessage, cause.getMessage()));
                }
                this.delegate().cancel(message, cause);
            }

            @Override
            public void halfClose() {
                if (ClientTracingInterceptor.this.streaming) {
                    span.log("Finished sending messages");
                }
                this.delegate().halfClose();
            }

            @Override
            public void sendMessage(ReqT message) {
                if (ClientTracingInterceptor.this.streaming || ClientTracingInterceptor.this.verbose) {
                    span.log("Message sent");
                }
                this.delegate().sendMessage(message);
            }
        };
    }

    private Span createSpanFromParent(SpanContext parentSpanContext, String operationName) {
        Tracer.SpanBuilder spanBuilder = parentSpanContext == null ? this.tracer.buildSpan(operationName) : this.tracer.buildSpan(operationName).asChildOf(parentSpanContext);
        return spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.COMPONENT.getKey(), GrpcTags.COMPONENT_NAME).start();
    }

    public static enum ClientRequestAttribute {
        METHOD_TYPE("grpc.method_type"),
        METHOD_NAME("grpc.method_name"),
        DEADLINE("grpc.deadline_millis"),
        COMPRESSOR("grpc.compressor"),
        AUTHORITY("grpc.authority"),
        ALL_CALL_OPTIONS("grpc.call_options"),
        HEADERS("grpc.headers");

        final String key;

        private ClientRequestAttribute(String key) {
            this.key = key;
        }
    }

    public static class Builder {
        private final Tracer tracer;
        private OperationNameConstructor operationNameConstructor;
        private boolean streaming;
        private boolean verbose;
        private Set<ClientRequestAttribute> tracedAttributes;
        private ActiveSpanSource activeSpanSource;
        private ActiveSpanContextSource activeSpanContextSource;
        private ClientSpanDecorator clientSpanDecorator;
        private ClientCloseDecorator clientCloseDecorator;

        public Builder() {
            this(GlobalTracer.get());
        }

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.operationNameConstructor = OperationNameConstructor.DEFAULT;
            this.streaming = false;
            this.verbose = false;
            this.tracedAttributes = new HashSet<ClientRequestAttribute>();
            this.activeSpanSource = ActiveSpanSource.GRPC_CONTEXT;
            this.clientSpanDecorator = null;
        }

        public Builder withOperationName(OperationNameConstructor operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withTracedAttributes(ClientRequestAttribute ... tracedAttributes) {
            this.tracedAttributes = new HashSet<ClientRequestAttribute>(Arrays.asList(tracedAttributes));
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public Builder withActiveSpanSource(ActiveSpanSource activeSpanSource) {
            this.activeSpanSource = activeSpanSource;
            return this;
        }

        public Builder withActiveSpanContextSource(ActiveSpanContextSource activeSpanContextSource) {
            this.activeSpanContextSource = activeSpanContextSource;
            return this;
        }

        public Builder withClientSpanDecorator(ClientSpanDecorator clientSpanDecorator) {
            this.clientSpanDecorator = clientSpanDecorator;
            return this;
        }

        public Builder withClientCloseDecorator(ClientCloseDecorator clientCloseDecorator) {
            this.clientCloseDecorator = clientCloseDecorator;
            return this;
        }

        public ClientTracingInterceptor build() {
            return new ClientTracingInterceptor(this.tracer, this.operationNameConstructor, this.streaming, this.verbose, this.tracedAttributes, this.activeSpanSource, this.activeSpanContextSource, this.clientSpanDecorator, this.clientCloseDecorator);
        }
    }
}

