/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SQLFuture<V>
extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V> {
    public SQLFuture(ListenableFuture<V> delegate) {
        super(delegate);
    }

    public V checkedGet() throws SQLException {
        try {
            return this.get();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            throw this.mapException(exc);
        }
        catch (CancellationException | ExecutionException exc) {
            throw this.mapException(exc);
        }
    }

    public V checkedGet(long timeout, TimeUnit unit) throws TimeoutException, SQLException {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            throw this.mapException(exc);
        }
        catch (CancellationException | ExecutionException exc) {
            throw this.mapException(exc);
        }
    }

    protected SQLException mapException(Exception exc) {
        Throwable cause;
        if (exc instanceof ExecutionException && (cause = exc.getCause()) instanceof SQLException) {
            SQLException se = (SQLException)cause;
            try {
                Constructor<?> constructor = cause.getClass().getConstructor(String.class, String.class, Integer.TYPE, Throwable.class);
                return (SQLException)constructor.newInstance(se.getMessage(), se.getSQLState(), se.getErrorCode(), exc);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                throw new RuntimeException("SQLException subclass can't be instantiated: " + cause.getClass().getName(), e1);
            }
        }
        return new SQLException(exc);
    }
}

