/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.vitess.client.Context;
import io.vitess.client.Proto;
import io.vitess.client.RpcClient;
import io.vitess.client.SQLFuture;
import io.vitess.client.StreamIterator;
import io.vitess.client.VTSession;
import io.vitess.client.cursor.Cursor;
import io.vitess.client.cursor.CursorWithError;
import io.vitess.client.cursor.SimpleCursor;
import io.vitess.client.cursor.StreamCursor;
import io.vitess.proto.Query;
import io.vitess.proto.Vtgate;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VTGateConnection
implements Closeable {
    private final RpcClient client;

    public VTGateConnection(RpcClient client) {
        this.client = Preconditions.checkNotNull(client);
    }

    public SQLFuture<Cursor> execute(Context ctx, String query, @Nullable Map<String, ?> bindVars, final VTSession vtSession) throws SQLException {
        vtSession.checkCallIsAllowed("execute");
        Vtgate.ExecuteRequest.Builder requestBuilder = Vtgate.ExecuteRequest.newBuilder().setQuery(Proto.bindQuery(Preconditions.checkNotNull(query), bindVars)).setSession(vtSession.getSession());
        if (ctx.getCallerId() != null) {
            requestBuilder.setCallerId(ctx.getCallerId());
        }
        SQLFuture<Cursor> call = new SQLFuture<Cursor>(Futures.transformAsync(this.client.execute(ctx, requestBuilder.build()), new AsyncFunction<Vtgate.ExecuteResponse, Cursor>(){

            @Override
            public ListenableFuture<Cursor> apply(Vtgate.ExecuteResponse response) throws Exception {
                vtSession.setSession(response.getSession());
                Proto.checkError(response.getError());
                return Futures.immediateFuture(new SimpleCursor(response.getResult()));
            }
        }, MoreExecutors.directExecutor()));
        vtSession.setLastCall(call);
        return call;
    }

    public SQLFuture<List<CursorWithError>> executeBatch(Context ctx, List<String> queryList, @Nullable List<Map<String, ?>> bindVarsList, final VTSession vtSession) throws SQLException {
        vtSession.checkCallIsAllowed("executeBatch");
        ArrayList<Query.BoundQuery> queries = new ArrayList<Query.BoundQuery>();
        if (null != bindVarsList && bindVarsList.size() != queryList.size()) {
            throw new SQLDataException("Size of SQL Query list does not match the bind variables list");
        }
        for (int i = 0; i < queryList.size(); ++i) {
            queries.add(i, Proto.bindQuery(Preconditions.checkNotNull(queryList.get(i)), bindVarsList == null ? null : bindVarsList.get(i)));
        }
        Vtgate.ExecuteBatchRequest.Builder requestBuilder = Vtgate.ExecuteBatchRequest.newBuilder().addAllQueries(Preconditions.checkNotNull(queries)).setSession(vtSession.getSession());
        if (ctx.getCallerId() != null) {
            requestBuilder.setCallerId(ctx.getCallerId());
        }
        SQLFuture<List<CursorWithError>> call = new SQLFuture<List<CursorWithError>>(Futures.transformAsync(this.client.executeBatch(ctx, requestBuilder.build()), new AsyncFunction<Vtgate.ExecuteBatchResponse, List<CursorWithError>>(){

            @Override
            public ListenableFuture<List<CursorWithError>> apply(Vtgate.ExecuteBatchResponse response) throws Exception {
                vtSession.setSession(response.getSession());
                Proto.checkError(response.getError());
                return Futures.immediateFuture(Proto.fromQueryResponsesToCursorList(response.getResultsList()));
            }
        }, MoreExecutors.directExecutor()));
        vtSession.setLastCall(call);
        return call;
    }

    public Cursor streamExecute(Context ctx, String query, @Nullable Map<String, ?> bindVars, VTSession vtSession) throws SQLException {
        Vtgate.StreamExecuteRequest.Builder requestBuilder = Vtgate.StreamExecuteRequest.newBuilder().setQuery(Proto.bindQuery(Preconditions.checkNotNull(query), bindVars)).setSession(vtSession.getSession());
        if (ctx.getCallerId() != null) {
            requestBuilder.setCallerId(ctx.getCallerId());
        }
        return new StreamCursor(this.client.streamExecute(ctx, requestBuilder.build()));
    }

    StreamIterator<Vtgate.VStreamResponse> getVStream(Context ctx, Vtgate.VStreamRequest vstreamRequest) throws SQLException {
        Vtgate.VStreamRequest request = vstreamRequest;
        if (ctx.getCallerId() != null) {
            request = request.toBuilder().setCallerId(ctx.getCallerId()).build();
        }
        return this.client.getVStream(ctx, request);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public String toString() {
        return String.format("[VTGateConnection-%s client=%s]", Integer.toHexString(this.hashCode()), this.client.toString());
    }
}

