/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.cursor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import io.vitess.client.cursor.FieldMap;
import io.vitess.mysql.DateTime;
import io.vitess.proto.Query;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Row {
    private final FieldMap fieldMap;
    private final List<ByteString> values;
    private final Query.Row rawRow;
    private volatile boolean lastGetWasNull;

    public Row(FieldMap fieldMap, Query.Row rawRow) {
        this.fieldMap = fieldMap;
        this.rawRow = rawRow;
        this.values = Row.extractValues(rawRow.getLengthsList(), rawRow.getValues());
    }

    public Row(List<Query.Field> fields, Query.Row rawRow) {
        this.fieldMap = new FieldMap(fields);
        this.rawRow = rawRow;
        this.values = Row.extractValues(rawRow.getLengthsList(), rawRow.getValues());
    }

    @VisibleForTesting
    public Row(List<Query.Field> fields, List<ByteString> values) {
        this.fieldMap = new FieldMap(fields);
        this.rawRow = null;
        this.values = values;
    }

    private static Object convertFieldValue(Query.Field field, ByteString value) throws SQLException {
        switch (field.getType()) {
            case DECIMAL: {
                return new BigDecimal(value.toStringUtf8());
            }
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT24: 
            case UINT24: 
            case INT32: {
                return Integer.valueOf(value.toStringUtf8());
            }
            case UINT32: 
            case INT64: {
                return Long.valueOf(value.toStringUtf8());
            }
            case UINT64: {
                return new BigInteger(value.toStringUtf8());
            }
            case FLOAT32: {
                return Float.valueOf(value.toStringUtf8());
            }
            case FLOAT64: {
                return Double.valueOf(value.toStringUtf8());
            }
            case NULL_TYPE: {
                return null;
            }
            case DATE: {
                try {
                    return DateTime.parseDate(value.toStringUtf8());
                }
                catch (ParseException exc) {
                    throw new SQLDataException("Can't parse DATE: " + value.toStringUtf8(), exc);
                }
            }
            case TIME: {
                try {
                    return DateTime.parseTime(value.toStringUtf8());
                }
                catch (ParseException exc) {
                    throw new SQLDataException("Can't parse TIME: " + value.toStringUtf8(), exc);
                }
            }
            case DATETIME: 
            case TIMESTAMP: {
                try {
                    return DateTime.parseTimestamp(value.toStringUtf8());
                }
                catch (ParseException exc) {
                    throw new SQLDataException("Can't parse TIMESTAMP: " + value.toStringUtf8(), exc);
                }
            }
            case YEAR: {
                return Short.valueOf(value.toStringUtf8());
            }
            case ENUM: 
            case SET: {
                return value.toStringUtf8();
            }
            case BIT: 
            case TEXT: 
            case BLOB: 
            case VARCHAR: 
            case VARBINARY: 
            case CHAR: 
            case BINARY: 
            case GEOMETRY: 
            case JSON: {
                return value.toByteArray();
            }
        }
        throw new SQLDataException("unknown field type: " + field.getType());
    }

    private static List<ByteString> extractValues(List<Long> lengths, ByteString buf) {
        ArrayList<ByteString> list = new ArrayList<ByteString>(lengths.size());
        int start = 0;
        for (long len : lengths) {
            if (len < 0L) {
                list.add(null);
                continue;
            }
            list.add(buf.substring(start, start + (int)len));
            start = (int)((long)start + len);
        }
        return list;
    }

    public int size() {
        return this.values.size();
    }

    public List<Query.Field> getFields() {
        return this.fieldMap.getList();
    }

    public Query.Row getRowProto() {
        return this.rawRow;
    }

    public FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = this.fieldMap.getIndex(columnLabel);
        if (columnIndex == null) {
            throw new SQLDataException("column not found:" + columnLabel);
        }
        return columnIndex;
    }

    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    public Object getObject(int columnIndex) throws SQLException {
        ByteString rawValue = this.getRawValue(columnIndex);
        if (rawValue == null) {
            return null;
        }
        return Row.convertFieldValue(this.fieldMap.get(columnIndex), rawValue);
    }

    public ByteString getRawValue(String columnLabel) throws SQLException {
        return this.getRawValue(this.findColumn(columnLabel));
    }

    public ByteString getRawValue(int columnIndex) throws SQLException {
        Preconditions.checkArgument(columnIndex >= 1, "columnIndex out of range: %s", columnIndex);
        if (columnIndex > this.values.size()) {
            throw new SQLDataException("invalid columnIndex: " + columnIndex);
        }
        ByteString value = this.values.get(columnIndex - 1);
        this.lastGetWasNull = value == null;
        return value;
    }

    public InputStream getBinaryInputStream(String columnLabel) throws SQLException {
        return this.getBinaryInputStream(this.findColumn(columnLabel));
    }

    public InputStream getBinaryInputStream(int columnIndex) throws SQLException {
        ByteString rawValue = this.getRawValue(columnIndex);
        if (rawValue == null) {
            return null;
        }
        return rawValue.newInput();
    }

    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    public int getInt(int columnIndex) throws SQLException {
        Integer value = this.getObject(columnIndex, Integer.class);
        return value == null ? 0 : value;
    }

    public UnsignedLong getULong(String columnLabel) throws SQLException {
        return this.getULong(this.findColumn(columnLabel));
    }

    public UnsignedLong getULong(int columnIndex) throws SQLException {
        BigInteger longValue = this.getObject(columnIndex, BigInteger.class);
        return longValue == null ? null : UnsignedLong.fromLongBits(longValue.longValue());
    }

    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    public String getString(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, String.class);
    }

    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    public long getLong(int columnIndex) throws SQLException {
        Long value = this.getObject(columnIndex, Long.class);
        return value == null ? 0L : value;
    }

    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    public double getDouble(int columnIndex) throws SQLException {
        Double value = this.getObject(columnIndex, Double.class);
        return value == null ? 0.0 : value;
    }

    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    public float getFloat(int columnIndex) throws SQLException {
        Float value = this.getObject(columnIndex, Float.class);
        return value == null ? 0.0f : value.floatValue();
    }

    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), Calendar.getInstance());
    }

    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        ByteString rawValue = this.getRawValue(columnIndex);
        if (rawValue == null) {
            return null;
        }
        Query.Field field = this.fieldMap.get(columnIndex);
        if (field.getType() != Query.Type.DATE) {
            throw new SQLDataException("type mismatch, expected: " + Query.Type.DATE + ", actual: " + field.getType());
        }
        try {
            return DateTime.parseDate(rawValue.toStringUtf8(), cal);
        }
        catch (ParseException exc) {
            throw new SQLDataException("Can't parse DATE: " + rawValue.toStringUtf8(), exc);
        }
    }

    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), Calendar.getInstance());
    }

    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, Calendar.getInstance());
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        ByteString rawValue = this.getRawValue(columnIndex);
        if (rawValue == null) {
            return null;
        }
        Query.Field field = this.fieldMap.get(columnIndex);
        if (field.getType() != Query.Type.TIME) {
            throw new SQLDataException("type mismatch, expected: " + Query.Type.TIME + ", actual: " + field.getType());
        }
        try {
            return DateTime.parseTime(rawValue.toStringUtf8(), cal);
        }
        catch (ParseException exc) {
            throw new SQLDataException("Can't parse TIME: " + rawValue.toStringUtf8(), exc);
        }
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), Calendar.getInstance());
    }

    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        ByteString rawValue = this.getRawValue(columnIndex);
        if (rawValue == null) {
            return null;
        }
        Query.Field field = this.fieldMap.get(columnIndex);
        if (field.getType() != Query.Type.TIMESTAMP && field.getType() != Query.Type.DATETIME) {
            throw new SQLDataException("type mismatch, expected: " + Query.Type.TIMESTAMP + " or " + Query.Type.DATETIME + ", actual: " + field.getType());
        }
        try {
            return DateTime.parseTimestamp(rawValue.toStringUtf8(), cal);
        }
        catch (ParseException exc) {
            throw new SQLDataException("Can't parse TIMESTAMP: " + rawValue.toStringUtf8(), exc);
        }
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, byte[].class);
    }

    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, BigDecimal.class);
    }

    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    public short getShort(int columnIndex) throws SQLException {
        Short value = this.getObject(columnIndex, Short.class);
        return value == null ? (short)0 : value;
    }

    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object object = this.getObject(columnIndex);
        if (object != null && !type.isInstance(object)) {
            throw new SQLDataException("type mismatch, expected: " + type.getName() + ", actual: " + object.getClass().getName());
        }
        return (T)object;
    }

    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }
}

