/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.jdbc.ConnectionProperties;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessJDBCUrl;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class VitessDriver
implements Driver {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        VitessConnection connection = new VitessConnection(url, info);
        connection.connect();
        return connection;
    }

    @Override
    public boolean acceptsURL(String url) {
        return null != url && url.startsWith("jdbc:vitess://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (null == info) {
            info = new Properties();
        }
        DriverPropertyInfo[] dpi = ConnectionProperties.exposeAsDriverPropertyInfo(info, 2);
        if (!this.acceptsURL(url)) {
            throw new SQLException("Connection URL is invalid : " + url);
        }
        VitessJDBCUrl vitessJDBCUrl = new VitessJDBCUrl(url, info);
        dpi[0] = new DriverPropertyInfo("host", vitessJDBCUrl.getHostInfos().get(0).getHostname());
        dpi[0].required = true;
        dpi[0].description = "Hostname of Vitess Server";
        dpi[1] = new DriverPropertyInfo("port", new Integer(vitessJDBCUrl.getHostInfos().get(0).getPort()).toString());
        dpi[1].required = false;
        dpi[1].description = "Port number of Vitess Server";
        return dpi;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    static {
        try {
            DriverManager.registerDriver(new VitessDriver());
        }
        catch (SQLException exc) {
            throw new RuntimeException("Failed to Initialize Vitess JDBC Driver : " + exc.getErrorCode() + " - " + exc.getMessage());
        }
    }
}

