/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import com.google.common.annotations.VisibleForTesting;
import io.vitess.jdbc.ConnectionProperties;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessDatabaseMetaData;
import io.vitess.jdbc.VitessResultSet;
import io.vitess.jdbc.VitessStatement;
import io.vitess.proto.Query;
import io.vitess.util.MysqlDefs;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class VitessMySQLDatabaseMetadata
extends VitessDatabaseMetaData
implements DatabaseMetaData {
    private static final String DRIVER_NAME = "Vitess MySQL JDBC Driver";
    private static String mysqlKeywordsThatArentSQL92;
    private int maxBufferSize = 65535;

    public VitessMySQLDatabaseMetadata(VitessConnection connection) throws SQLException {
        this.setConnection(connection);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return mysqlKeywordsThatArentSQL92;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return super.getSystemFunctions() + ",PASSWORD,ENCRYPT";
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 65531;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.getDbProperties().getIsolationLevel();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet resultSet = null;
        VitessStatement vitessStatement = null;
        boolean reportTables = false;
        boolean reportViews = false;
        boolean reportSystemTables = false;
        boolean reportSystemViews = false;
        boolean reportLocalTemporaries = false;
        TreeMap sortedRows = new TreeMap();
        if (null == tableNamePattern) {
            tableNamePattern = "%";
        }
        if (null == catalog || catalog.length() == 0) {
            catalog = this.connection.getCatalog();
        }
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        try {
            boolean hasTableTypes;
            vitessStatement = new VitessStatement(this.connection);
            StringBuilder stringBuilder = new StringBuilder().append("SHOW FULL TABLES FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder2 = stringBuilder.append("`").append(catalog);
            Objects.requireNonNull(this);
            resultSet = vitessStatement.executeQuery(stringBuilder2.append("`").append(" LIKE '").append(tableNamePattern).append("'").toString());
            if (null == types || types.length == 0) {
                reportLocalTemporaries = true;
                reportSystemViews = true;
                reportSystemTables = true;
                reportViews = true;
                reportTables = true;
            } else {
                for (String type : types) {
                    if (TableType.TABLE.equalsTo(type)) {
                        reportTables = true;
                        continue;
                    }
                    if (TableType.VIEW.equalsTo(type)) {
                        reportViews = true;
                        continue;
                    }
                    if (TableType.SYSTEM_TABLE.equalsTo(type)) {
                        reportSystemTables = true;
                        continue;
                    }
                    if (TableType.SYSTEM_VIEW.equalsTo(type)) {
                        reportSystemViews = true;
                        continue;
                    }
                    if (!TableType.LOCAL_TEMPORARY.equalsTo(type)) continue;
                    reportLocalTemporaries = true;
                }
            }
            int typeColumnIndex = 0;
            try {
                typeColumnIndex = resultSet.findColumn("table_type");
                hasTableTypes = true;
            }
            catch (SQLException sqlEx) {
                try {
                    typeColumnIndex = resultSet.findColumn("Type");
                    hasTableTypes = true;
                }
                catch (SQLException sqlEx2) {
                    hasTableTypes = false;
                }
            }
            while (resultSet.next()) {
                ArrayList<String> row;
                block35: {
                    block34: {
                        row = new ArrayList<String>();
                        row.add(0, catalog);
                        row.add(1, null);
                        row.add(2, resultSet.getString(1));
                        row.add(3, "");
                        row.add(4, null);
                        row.add(5, null);
                        row.add(6, null);
                        row.add(7, null);
                        row.add(8, null);
                        row.add(9, null);
                        if (!hasTableTypes) break block34;
                        String tableType = resultSet.getString(typeColumnIndex);
                        switch (TableType.getTableTypeCompliantWith(tableType)) {
                            case TABLE: {
                                boolean reportTable = false;
                                TableMetaDataKey tablesKey = null;
                                if (reportSystemTables) {
                                    row.add(3, TableType.TABLE.toString());
                                    tablesKey = new TableMetaDataKey(TableType.TABLE.getName(), catalog, null, resultSet.getString(1));
                                    reportTable = true;
                                }
                                if (reportTable) {
                                    sortedRows.put(tablesKey, row);
                                    break;
                                }
                                break block35;
                            }
                            case VIEW: {
                                if (reportViews) {
                                    row.add(3, TableType.VIEW.toString());
                                    sortedRows.put(new TableMetaDataKey(TableType.VIEW.getName(), catalog, null, resultSet.getString(1)), row);
                                    break;
                                }
                                break block35;
                            }
                            case SYSTEM_TABLE: {
                                if (reportSystemTables) {
                                    row.add(3, TableType.SYSTEM_TABLE.toString());
                                    sortedRows.put(new TableMetaDataKey(TableType.SYSTEM_TABLE.getName(), catalog, null, resultSet.getString(1)), row);
                                    break;
                                }
                                break block35;
                            }
                            case SYSTEM_VIEW: {
                                if (reportSystemViews) {
                                    row.add(3, TableType.SYSTEM_VIEW.toString());
                                    sortedRows.put(new TableMetaDataKey(TableType.SYSTEM_VIEW.getName(), catalog, null, resultSet.getString(1)), row);
                                    break;
                                }
                                break block35;
                            }
                            case LOCAL_TEMPORARY: {
                                if (reportLocalTemporaries) {
                                    row.add(3, TableType.LOCAL_TEMPORARY.toString());
                                    sortedRows.put(new TableMetaDataKey(TableType.LOCAL_TEMPORARY.getName(), catalog, null, resultSet.getString(1)), row);
                                    break;
                                }
                                break block35;
                            }
                            default: {
                                row.add(3, TableType.TABLE.toString());
                                sortedRows.put(new TableMetaDataKey(TableType.TABLE.getName(), catalog, null, resultSet.getString(1)), row);
                                break;
                            }
                        }
                        break block35;
                    }
                    if (reportTables) {
                        row.add(3, TableType.TABLE.toString());
                        sortedRows.put(new TableMetaDataKey(TableType.TABLE.getName(), catalog, null, resultSet.getString(1)), row);
                    }
                }
                data.add(row);
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
            if (null != vitessStatement) {
                vitessStatement.close();
            }
        }
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        Query.Type[] columnTypes = new Query.Type[]{Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR};
        return new VitessResultSet(columnNames, columnTypes, data, this.connection);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String[] columnNames = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String getCatalogQB = "SHOW DATABASES";
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        ResultSet resultSet = vitessStatement.executeQuery(getCatalogQB);
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        while (resultSet.next()) {
            row.add(resultSet.getString(1));
        }
        Collections.sort(row);
        for (String result : row) {
            ArrayList<String> resultAsList = new ArrayList<String>();
            resultAsList.add(result);
            data.add(resultAsList);
        }
        resultSet.close();
        vitessStatement.close();
        String[] columnName = new String[]{"TABLE_CAT"};
        Query.Type[] columntype = new Query.Type[]{Query.Type.CHAR};
        return new VitessResultSet(columnName, columntype, data, this.connection);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String[] columnNames = new String[]{"table_type"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.VARCHAR};
        String[][] data = new String[][]{{"LOCAL TEMPORARY"}, {"SYSTEM TABLES"}, {"SYSTEM VIEW"}, {"TABLE"}, {"VIEW"}};
        return new VitessResultSet(columnNames, columnType, data, (ConnectionProperties)this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet resultSet = null;
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        if (null == columnNamePattern) {
            columnNamePattern = "%";
        }
        if (null == catalog || catalog.length() == 0) {
            catalog = this.connection.getCatalog();
        }
        try {
            String tableName;
            ArrayList<String> tableList = new ArrayList<String>();
            ResultSet tables = null;
            if (null == tableNamePattern) {
                try {
                    tables = this.getTables(catalog, schemaPattern, "%", new String[0]);
                    while (tables.next()) {
                        tableName = tables.getString("TABLE_NAME");
                        tableList.add(tableName);
                    }
                }
                finally {
                    if (null != tables) {
                        tables.close();
                    }
                }
            }
            try {
                tables = this.getTables(catalog, schemaPattern, tableNamePattern, new String[0]);
                while (tables.next()) {
                    tableName = tables.getString("TABLE_NAME");
                    tableList.add(tableName);
                }
            }
            finally {
                if (null != tables) {
                    tables.close();
                }
            }
            for (String tableName2 : tableList) {
                resultSet = null;
                try {
                    boolean fixUpOrdinalsRequired = false;
                    HashMap<String, Integer> ordinalFixUpMap = null;
                    if (!columnNamePattern.equals("%")) {
                        fixUpOrdinalsRequired = true;
                        vitessStatement = new VitessStatement(this.connection);
                        StringBuilder stringBuilder = new StringBuilder().append("SHOW FULL COLUMNS FROM ");
                        Objects.requireNonNull(this);
                        StringBuilder stringBuilder2 = stringBuilder.append("`").append(tableName2);
                        Objects.requireNonNull(this);
                        StringBuilder stringBuilder3 = stringBuilder2.append("`").append(" FROM ");
                        Objects.requireNonNull(this);
                        StringBuilder stringBuilder4 = stringBuilder3.append("`").append(catalog);
                        Objects.requireNonNull(this);
                        resultSet = vitessStatement.executeQuery(stringBuilder4.append("`").toString());
                        ordinalFixUpMap = new HashMap<String, Integer>();
                        int fullOrdinalPos = 1;
                        while (resultSet.next()) {
                            String fullOrdColName = resultSet.getString("Field");
                            ordinalFixUpMap.put(fullOrdColName, fullOrdinalPos++);
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("SHOW FULL COLUMNS FROM ");
                    Objects.requireNonNull(this);
                    StringBuilder stringBuilder5 = stringBuilder.append("`").append(tableName2);
                    Objects.requireNonNull(this);
                    StringBuilder stringBuilder6 = stringBuilder5.append("`").append(" FROM ");
                    Objects.requireNonNull(this);
                    StringBuilder stringBuilder7 = stringBuilder6.append("`").append(catalog);
                    Objects.requireNonNull(this);
                    resultSet = vitessStatement.executeQuery(stringBuilder7.append("`").append(" LIKE ").append("'").append(columnNamePattern).append("'").toString());
                    int ordPos = 1;
                    while (resultSet.next()) {
                        ArrayList<String> row = new ArrayList<String>();
                        row.add(0, catalog);
                        row.add(1, null);
                        row.add(2, tableName2);
                        row.add(3, resultSet.getString("Field"));
                        TypeDescriptor typeDesc = new TypeDescriptor(resultSet.getString("Type"), resultSet.getString("Null"));
                        row.add(4, Short.toString(typeDesc.dataType));
                        row.add(5, typeDesc.typeName);
                        if (null == typeDesc.columnSize) {
                            row.add(6, null);
                        } else {
                            String collation = resultSet.getString("Collation");
                            int mbminlen = 1;
                            if (collation != null && ("TEXT".equals(typeDesc.typeName) || "TINYTEXT".equals(typeDesc.typeName) || "MEDIUMTEXT".equals(typeDesc.typeName))) {
                                if (collation.indexOf("ucs2") > -1 || collation.indexOf("utf16") > -1) {
                                    mbminlen = 2;
                                } else if (collation.indexOf("utf32") > -1) {
                                    mbminlen = 4;
                                }
                            }
                            row.add(6, mbminlen == 1 ? typeDesc.columnSize.toString() : Integer.toString(typeDesc.columnSize / mbminlen));
                        }
                        row.add(7, Integer.toString(typeDesc.bufferLength));
                        row.add(8, typeDesc.decimalDigits == null ? null : typeDesc.decimalDigits.toString());
                        row.add(9, Integer.toString(typeDesc.numPrecRadix));
                        row.add(10, Integer.toString(typeDesc.nullability));
                        row.add(11, "Comment");
                        row.add(12, resultSet.getString("Default") == null ? null : resultSet.getString("Default"));
                        row.add(13, Integer.toString(0));
                        row.add(14, Integer.toString(0));
                        if (StringUtils.indexOfIgnoreCase(typeDesc.typeName, "CHAR") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "BLOB") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "TEXT") != -1 || StringUtils.indexOfIgnoreCase(typeDesc.typeName, "BINARY") != -1) {
                            row.add(15, (String)row.get(6));
                        } else {
                            row.add(15, Integer.toString(0));
                        }
                        if (!fixUpOrdinalsRequired) {
                            row.add(16, Integer.toString(ordPos++));
                        } else {
                            String origColName = resultSet.getString("Field");
                            Integer realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                            if (realOrdinal != null) {
                                row.add(16, realOrdinal.toString());
                            } else {
                                throw new SQLException("Can not find column in full column list to determine true ordinal position.");
                            }
                        }
                        row.add(17, typeDesc.isNullable);
                        row.add(18, null);
                        row.add(19, null);
                        row.add(20, null);
                        row.add(21, null);
                        String extra = resultSet.getString("Extra");
                        if (null != extra) {
                            row.add(22, StringUtils.indexOfIgnoreCase(extra, "auto_increment") != -1 ? "YES" : "NO");
                            row.add(23, StringUtils.indexOfIgnoreCase(extra, "generated") != -1 ? "YES" : "NO");
                        }
                        data.add(row);
                    }
                }
                finally {
                    if (null == resultSet) continue;
                    resultSet.close();
                }
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
            vitessStatement.close();
        }
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT32, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16, Query.Type.CHAR, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, data, this.connection);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet resultSet = null;
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        if (null == table) {
            throw new SQLException("Table Parameter cannot be null in getBestRowIdentifier");
        }
        String[] columnName = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.INT16, Query.Type.CHAR, Query.Type.INT32, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT16, Query.Type.INT16};
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("SHOW COLUMNS FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder2 = stringBuilder.append("`").append(table);
            Objects.requireNonNull(this);
            StringBuilder stringBuilder3 = stringBuilder2.append("`").append(" FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder4 = stringBuilder3.append("`").append(catalog);
            Objects.requireNonNull(this);
            resultSet = vitessStatement.executeQuery(stringBuilder4.append("`").toString());
            while (resultSet.next()) {
                ArrayList<String> row = new ArrayList<String>();
                String keyType = resultSet.getString("Key");
                if (keyType == null || !StringUtils.startsWithIgnoreCase(keyType, "PRI")) continue;
                row.add(Integer.toString(2));
                row.add(resultSet.getString("Field"));
                String type = resultSet.getString("Type");
                int size = this.maxBufferSize;
                int decimals = 0;
                if (type.indexOf("enum") != -1) {
                    String temp = type.substring(type.indexOf("("), type.indexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    int maxLength = 0;
                    while (tokenizer.hasMoreTokens()) {
                        maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                    }
                    size = maxLength;
                    decimals = 0;
                    type = "enum";
                } else if (type.indexOf("(") != -1) {
                    if (type.indexOf(",") != -1) {
                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(",")));
                        decimals = Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(")")));
                    } else {
                        size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(")")));
                    }
                    type = type.substring(0, type.indexOf("("));
                }
                row.add(Integer.toString(MysqlDefs.mysqlToJavaType(type)));
                row.add(type);
                row.add(Integer.toString(size + decimals));
                row.add(Integer.toString(size + decimals));
                row.add(Integer.toString(decimals));
                row.add(Integer.toString(1));
                data.add(row);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            vitessStatement.close();
        }
        return new VitessResultSet(columnName, columnType, data, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (null == table) {
            throw new SQLException("Table cannot be null");
        }
        ResultSet resultSet = null;
        VitessStatement vitessStatement = null;
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        StringBuilder getVersionColumnsQB = new StringBuilder();
        getVersionColumnsQB.append("SHOW COLUMNS FROM ");
        Objects.requireNonNull(this);
        getVersionColumnsQB.append("`");
        getVersionColumnsQB.append(table);
        Objects.requireNonNull(this);
        getVersionColumnsQB.append("`");
        getVersionColumnsQB.append(" FROM ");
        Objects.requireNonNull(this);
        getVersionColumnsQB.append("`");
        getVersionColumnsQB.append(catalog);
        Objects.requireNonNull(this);
        getVersionColumnsQB.append("`");
        getVersionColumnsQB.append(" WHERE Extra LIKE '%on update CURRENT_TIMESTAMP%'");
        try {
            vitessStatement = new VitessStatement(this.connection);
            resultSet = vitessStatement.executeQuery(getVersionColumnsQB.toString());
            while (resultSet.next()) {
                ArrayList<String> row = new ArrayList<String>();
                TypeDescriptor typeDesc = new TypeDescriptor(resultSet.getString("Type"), resultSet.getString("Null"));
                row.add(0, null);
                row.add(1, resultSet.getString("Field"));
                row.add(2, Short.toString(typeDesc.dataType));
                row.add(3, typeDesc.typeName);
                row.add(4, typeDesc.columnSize == null ? null : typeDesc.columnSize.toString());
                row.add(5, Integer.toString(typeDesc.bufferLength));
                row.add(6, typeDesc.decimalDigits == null ? null : typeDesc.decimalDigits.toString());
                row.add(7, Integer.toString(1));
                data.add(row);
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
                vitessStatement.close();
            }
        }
        String[] columnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.INT16, Query.Type.CHAR, Query.Type.INT32, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT16, Query.Type.INT16};
        return new VitessResultSet(columnNames, columnType, data, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (null == table) {
            throw new SQLException("Table Name Cannot be Null");
        }
        ResultSet resultSet = null;
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        ArrayList<ArrayList<String>> sortedData = new ArrayList<ArrayList<String>>();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("SHOW KEYS FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder2 = stringBuilder.append("`").append(table);
            Objects.requireNonNull(this);
            StringBuilder stringBuilder3 = stringBuilder2.append("`").append(" FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder4 = stringBuilder3.append("`").append(catalog);
            Objects.requireNonNull(this);
            resultSet = vitessStatement.executeQuery(stringBuilder4.append("`").toString());
            TreeMap<String, ArrayList> sortMap = new TreeMap<String, ArrayList>();
            while (resultSet.next()) {
                String keyType = resultSet.getString("Key_name");
                ArrayList row = new ArrayList();
                if (null == keyType || !keyType.equalsIgnoreCase("PRIMARY") && !keyType.equalsIgnoreCase("PRI")) continue;
                row.add(0, catalog == null ? "" : catalog);
                row.add(1, null);
                row.add(2, table);
                String columnName = resultSet.getString("Column_name");
                row.add(3, columnName);
                row.add(4, resultSet.getString("Seq_in_index"));
                row.add(5, keyType);
                sortMap.put(columnName, row);
            }
            for (ArrayList row : sortMap.values()) {
                sortedData.add(row);
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
            vitessStatement.close();
        }
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, sortedData, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (null == table) {
            throw new SQLException("Table Name Cannot be Null");
        }
        ResultSet resultSet = null;
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        ArrayList<ArrayList<String>> rows = new ArrayList<ArrayList<String>>();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("SHOW CREATE TABLE ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder2 = stringBuilder.append("`").append(table);
            Objects.requireNonNull(this);
            resultSet = vitessStatement.executeQuery(stringBuilder2.append("`").toString());
            while (resultSet.next()) {
                this.extractForeignKeyForTable(rows, resultSet.getString(2), catalog, table);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16, Query.Type.INT16, Query.Type.INT16, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16};
        return new VitessResultSet(columnNames, columnType, rows, this.connection);
    }

    @VisibleForTesting
    void extractForeignKeyForTable(List<ArrayList<String>> rows, String createTableString, String catalog, String table) throws SQLException {
        StringTokenizer lineTokenizer = new StringTokenizer(createTableString, "\n");
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken().trim();
            String constraintName = null;
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT")) {
                boolean usingBackTicks = true;
                Objects.requireNonNull(this);
                int beginPos = io.vitess.util.StringUtils.indexOfQuoteDoubleAware(line, "`", 0);
                if (beginPos == -1) {
                    beginPos = line.indexOf("\"");
                    usingBackTicks = false;
                }
                if (beginPos != -1) {
                    int endPos;
                    if (usingBackTicks) {
                        Objects.requireNonNull(this);
                        endPos = io.vitess.util.StringUtils.indexOfQuoteDoubleAware(line, "`", beginPos + 1);
                    } else {
                        endPos = io.vitess.util.StringUtils.indexOfQuoteDoubleAware(line, "\"", beginPos + 1);
                    }
                    if (endPos != -1) {
                        constraintName = line.substring(beginPos + 1, endPos);
                        line = line.substring(endPos + 1, line.length()).trim();
                    }
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            int indexOfFK = line.indexOf("FOREIGN KEY");
            String localColumnName = null;
            Objects.requireNonNull(this);
            String referencedCatalogName = io.vitess.util.StringUtils.quoteIdentifier(catalog, "`");
            String referencedTableName = null;
            String referencedColumnName = null;
            if (indexOfFK != -1) {
                int afterFk = indexOfFK + "FOREIGN KEY".length();
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                int indexOfRef = io.vitess.util.StringUtils.indexOfIgnoreCase(afterFk, line, "REFERENCES", "`", "`");
                if (indexOfRef != -1) {
                    int indexOfParenOpen = line.indexOf(40, afterFk);
                    Objects.requireNonNull(this);
                    Objects.requireNonNull(this);
                    int indexOfParenClose = io.vitess.util.StringUtils.indexOfIgnoreCase(indexOfParenOpen, line, ")", "`", "`");
                    localColumnName = line.substring(indexOfParenOpen + 1, indexOfParenClose);
                    int afterRef = indexOfRef + "REFERENCES".length();
                    Objects.requireNonNull(this);
                    Objects.requireNonNull(this);
                    int referencedColumnBegin = io.vitess.util.StringUtils.indexOfIgnoreCase(afterRef, line, "(", "`", "`");
                    if (referencedColumnBegin != -1) {
                        referencedTableName = line.substring(afterRef, referencedColumnBegin);
                        Objects.requireNonNull(this);
                        Objects.requireNonNull(this);
                        int referencedColumnEnd = io.vitess.util.StringUtils.indexOfIgnoreCase(referencedColumnBegin + 1, line, ")", "`", "`");
                        if (referencedColumnEnd != -1) {
                            referencedColumnName = line.substring(referencedColumnBegin + 1, referencedColumnEnd);
                        }
                        Objects.requireNonNull(this);
                        Objects.requireNonNull(this);
                        int indexOfCatalogSep = io.vitess.util.StringUtils.indexOfIgnoreCase(0, referencedTableName, ".", "`", "`");
                        if (indexOfCatalogSep != -1) {
                            referencedCatalogName = referencedTableName.substring(0, indexOfCatalogSep);
                            referencedTableName = referencedTableName.substring(indexOfCatalogSep + 1);
                        }
                    }
                }
            }
            if (constraintName == null) {
                constraintName = "not_available";
            }
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            List<String> localColumnsList = io.vitess.util.StringUtils.split(localColumnName, ",", "`", "`");
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            List<String> referColumnsList = io.vitess.util.StringUtils.split(referencedColumnName, ",", "`", "`");
            if (localColumnsList.size() != referColumnsList.size()) {
                throw new SQLException("Mismatch columns list for foreign key local and reference columns");
            }
            for (int i = 0; i < localColumnsList.size(); ++i) {
                String localColumn = localColumnsList.get(i);
                String referColumn = referColumnsList.get(i);
                ArrayList<String> row = new ArrayList<String>(14);
                Objects.requireNonNull(this);
                row.add(io.vitess.util.StringUtils.unQuoteIdentifier(referencedCatalogName, "`"));
                row.add(null);
                Objects.requireNonNull(this);
                row.add(io.vitess.util.StringUtils.unQuoteIdentifier(referencedTableName, "`"));
                Objects.requireNonNull(this);
                row.add(io.vitess.util.StringUtils.unQuoteIdentifier(referColumn, "`"));
                row.add(catalog);
                row.add(null);
                row.add(table);
                Objects.requireNonNull(this);
                row.add(io.vitess.util.StringUtils.unQuoteIdentifier(localColumn, "`"));
                row.add(Integer.toString(i + 1));
                int[] actions = this.getForeignKeyActions(line);
                row.add(Integer.toString(actions[1]));
                row.add(Integer.toString(actions[0]));
                row.add(constraintName);
                row.add(null);
                row.add(Integer.toString(7));
                rows.add(row);
            }
        }
    }

    private int[] getForeignKeyActions(String constraint) {
        int[] actions = new int[]{3, 3};
        int lastParenIndex = constraint.lastIndexOf(")");
        if (lastParenIndex != constraint.length() - 1) {
            String cascadeOptions = constraint.substring(lastParenIndex + 1).trim().toUpperCase(Locale.ENGLISH);
            actions[0] = this.getCascadeDeleteOption(cascadeOptions);
            actions[1] = this.getCascadeUpdateOption(cascadeOptions);
        }
        return actions;
    }

    private int getCascadeDeleteOption(String cascadeOptions) {
        int onDeletePos = cascadeOptions.indexOf("ON DELETE");
        if (onDeletePos != -1) {
            String deleteOptions = cascadeOptions.substring(onDeletePos, cascadeOptions.length());
            if (deleteOptions.startsWith("ON DELETE CASCADE")) {
                return 0;
            }
            if (deleteOptions.startsWith("ON DELETE SET NULL")) {
                return 2;
            }
            if (deleteOptions.startsWith("ON DELETE RESTRICT")) {
                return 1;
            }
            if (deleteOptions.startsWith("ON DELETE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    private int getCascadeUpdateOption(String cascadeOptions) {
        int onUpdatePos = cascadeOptions.indexOf("ON UPDATE");
        if (onUpdatePos != -1) {
            String updateOptions = cascadeOptions.substring(onUpdatePos, cascadeOptions.length());
            if (updateOptions.startsWith("ON UPDATE CASCADE")) {
                return 0;
            }
            if (updateOptions.startsWith("ON UPDATE SET NULL")) {
                return 2;
            }
            if (updateOptions.startsWith("ON UPDATE RESTRICT")) {
                return 1;
            }
            if (updateOptions.startsWith("ON UPDATE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String[] columnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        Query.Type[] columnTypes = new Query.Type[]{Query.Type.VARCHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.INT32, Query.Type.BIT, Query.Type.INT16, Query.Type.BIT, Query.Type.BIT, Query.Type.BIT, Query.Type.VARCHAR, Query.Type.INT16, Query.Type.INT16, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32};
        String[][] data = new String[][]{{"BIT", "-7", "1", "", "", "", "1", "true", "3", "false", "false", "false", "BIT", "0", "0", "0", "0", "10"}, {"BOOL", "-7", "1", "", "", "", "1", "true", "3", "false", "false", "false", "BOOL", "0", "0", "0", "0", "10"}, {"TINYINT", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "TINYINT", "0", "0", "0", "0", "10"}, {"TINYINT UNSIGNED", "-6", "3", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "TINYINT UNSIGNED", "0", "0", "0", "0", "10"}, {"BIGINT", "-5", "19", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "BIGINT", "0", "0", "0", "0", "10"}, {"BIGINT UNSIGNED", "-5", "20", "", "", "[(M)] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "BIGINT UNSIGNED", "0", "0", "0", "0", "10"}, {"LONG VARBINARY", "-4", "16777215", "'", "'", "", "1", "true", "3", "false", "false", "false", "LONG VARBINARY", "0", "0", "0", "0", "10"}, {"MEDIUMBLOB", "-4", "16777215", "'", "'", "", "1", "true", "3", "false", "false", "false", "MEDIUMBLOB", "0", "0", "0", "0", "10"}, {"LONGBLOB", "-4", "2147483647", "'", "'", "", "1", "true", "3", "false", "false", "false", "LONGBLOB", "0", "0", "0", "0", "10"}, {"BLOB", "-4", "65535", "'", "'", "", "1", "true", "3", "false", "false", "false", "BLOB", "0", "0", "0", "0", "10"}, {"TINYBLOB", "-4", "255", "'", "'", "", "1", "true", "3", "false", "false", "false", "TINYBLOB", "0", "0", "0", "0", "10"}, {"VARBINARY", "-3", "65535", "'", "'", "(M)", "1", "true", "3", "false", "false", "false", "VARBINARY", "0", "0", "0", "0", "10"}, {"BINARY", "-2", "255", "'", "'", "(M)", "1", "true", "3", "false", "false", "false", "BINARY", "0", "0", "0", "0", "10"}, {"LONG VARCHAR", "-1", "16777215", "'", "'", "", "1", "false", "3", "false", "false", "false", "LONG VARCHAR", "0", "0", "0", "0", "10"}, {"MEDIUMTEXT", "-1", "16777215", "'", "'", "", "1", "false", "3", "false", "false", "false", "MEDIUMTEXT", "0", "0", "0", "0", "10"}, {"LONGTEXT", "-1", "2147483647", "'", "'", "", "1", "false", "3", "false", "false", "false", "LONGTEXT", "0", "0", "0", "0", "10"}, {"TEXT", "-1", "65535", "'", "'", "", "1", "false", "3", "false", "false", "false", "TEXT", "0", "0", "0", "0", "10"}, {"TINYTEXT", "-1", "255", "'", "'", "", "1", "false", "3", "false", "false", "false", "TINYTEXT", "0", "0", "0", "0", "10"}, {"CHAR", "1", "255", "'", "'", "(M)", "1", "false", "3", "false", "false", "false", "CHAR", "0", "0", "0", "0", "10"}, {"NUMERIC", "2", "65", "", "", "[(M[,D])] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "NUMERIC", "-308", "308", "0", "0", "10"}, {"DECIMAL", "3", "65", "", "", "[(M[,D])] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "DECIMAL", "-308", "308", "0", "0", "10"}, {"INTEGER", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "INTEGER", "0", "0", "0", "0", "10"}, {"INTEGER UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "INTEGER UNSIGNED", "0", "0", "0", "0", "10"}, {"INT", "4", "10", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "INT", "0", "0", "0", "0", "10"}, {"INT UNSIGNED", "4", "10", "", "", "[(M)] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "INT UNSIGNED", "0", "0", "0", "0", "10"}, {"MEDIUMINT", "4", "7", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "MEDIUMINT", "0", "0", "0", "0", "10"}, {"MEDIUMINT UNSIGNED", "4", "8", "", "", "[(M)] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "MEDIUMINT UNSIGNED", "0", "0", "0", "0", "10"}, {"SMALLINT", "5", "5", "", "", "[(M)] [UNSIGNED] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "SMALLINT", "0", "0", "0", "0", "10"}, {"SMALLINT UNSIGNED", "5", "5", "", "", "[(M)] [ZEROFILL]", "1", "false", "3", "true", "false", "true", "SMALLINT UNSIGNED", "0", "0", "0", "0", "10"}, {"FLOAT", "7", "10", "", "", "[(M,D)] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "FLOAT", "-38", "38", "0", "0", "10"}, {"DOUBLE", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "DOUBLE", "-308", "308", "0", "0", "10"}, {"DOUBLE PRECISION", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "DOUBLE PRECISION", "-308", "308", "0", "0", "10"}, {"REAL", "8", "17", "", "", "[(M,D)] [ZEROFILL]", "1", "false", "3", "false", "false", "true", "REAL", "-308", "308", "0", "0", "10"}, {"VARCHAR", "12", "65535", "'", "'", "(M)", "1", "false", "3", "false", "false", "false", "VARCHAR", "0", "0", "0", "0", "10"}, {"ENUM", "12", "65535", "'", "'", "", "1", "false", "3", "false", "false", "false", "ENUM", "0", "0", "0", "0", "10"}, {"SET", "12", "64", "'", "'", "", "1", "false", "3", "false", "false", "false", "SET", "0", "0", "0", "0", "10"}, {"DATE", "91", "0", "'", "'", "", "1", "false", "3", "false", "false", "false", "DATE", "0", "0", "0", "0", "10"}, {"TIME", "92", "0", "'", "'", "", "1", "false", "3", "false", "false", "false", "TIME", "0", "0", "0", "0", "10"}, {"DATETIME", "93", "0", "'", "'", "", "1", "false", "3", "false", "false", "false", "DATETIME", "0", "0", "0", "0", "10"}, {"TIMESTAMP", "93", "0", "'", "'", "[(M)]", "1", "false", "3", "false", "false", "false", "TIMESTAMP", "0", "0", "0", "0", "10"}};
        return new VitessResultSet(columnNames, columnTypes, data, (ConnectionProperties)this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        TreeMap<IndexMetaDataKey, Object> sortedRows = new TreeMap<IndexMetaDataKey, Object>();
        VitessStatement vitessStatement = new VitessStatement(this.connection);
        ResultSet resultSet = null;
        try {
            StringBuilder stringBuilder = new StringBuilder().append("SHOW INDEX FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder2 = stringBuilder.append("`").append(table);
            Objects.requireNonNull(this);
            StringBuilder stringBuilder3 = stringBuilder2.append("`").append(" FROM ");
            Objects.requireNonNull(this);
            StringBuilder stringBuilder4 = stringBuilder3.append("`").append(catalog);
            Objects.requireNonNull(this);
            resultSet = vitessStatement.executeQuery(stringBuilder4.append("`").toString());
            while (resultSet.next()) {
                ArrayList row = new ArrayList();
                row.add(0, catalog);
                row.add(1, null);
                row.add(2, resultSet.getString("Table"));
                boolean indexIsUnique = resultSet.getInt("Non_unique") == 0;
                row.add(3, !indexIsUnique ? "true" : "false");
                row.add(4, "");
                row.add(5, resultSet.getString("Key_name"));
                short indexType = 3;
                row.add(6, Integer.toString(indexType));
                row.add(7, resultSet.getString("Seq_in_index"));
                row.add(8, resultSet.getString("Column_name"));
                row.add(9, resultSet.getString("Collation"));
                long cardinality = resultSet.getLong("Cardinality");
                if (cardinality > Integer.MAX_VALUE) {
                    cardinality = Integer.MAX_VALUE;
                }
                row.add(10, String.valueOf(cardinality));
                row.add(11, "0");
                row.add(12, null);
                IndexMetaDataKey indexInfoKey = new IndexMetaDataKey(!indexIsUnique, indexType, resultSet.getString("Key_name").toLowerCase(), resultSet.getShort("Seq_in_index"));
                sortedRows.put(indexInfoKey, row);
            }
            for (ArrayList row : sortedRows.values()) {
                data.add(row);
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
            vitessStatement.close();
        }
        String[] columnName = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "Non_unique", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.BIT, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16, Query.Type.INT16, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.CHAR};
        return new VitessResultSet(columnName, columnType, data, this.connection);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.VARCHAR, Query.Type.INT32, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.INT32, Query.Type.VARCHAR, Query.Type.INT16};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TYPE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String[] columnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "ISNULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.CHAR, Query.Type.INT16};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_CATALOG"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.CHAR, Query.Type.CHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String[] columnNames = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.VARCHAR, Query.Type.INT32, Query.Type.VARCHAR, Query.Type.VARCHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "COLUMN_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "COLUMN_USAGE", "REMARKS", "CHAR_OCTET_LENGTH", "IS_NULLABLE"};
        Query.Type[] columnType = new Query.Type[]{Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.INT32, Query.Type.VARCHAR, Query.Type.VARCHAR, Query.Type.INT32, Query.Type.VARCHAR};
        return new VitessResultSet(columnNames, columnType, new String[0][], (ConnectionProperties)this.connection);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    static {
        String[] allMySQLKeywords = new String[]{"ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RANGE", "READ", "READS", "READ_ONLY", "READ_WRITE", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "X509", "XOR", "YEAR_MONTH", "ZEROFILL"};
        String[] sql92Keywords = new String[]{"ABSOLUTE", "EXEC", "OVERLAPS", "ACTION", "EXECUTE", "PAD", "ADA", "EXISTS", "PARTIAL", "ADD", "EXTERNAL", "PASCAL", "ALL", "EXTRACT", "POSITION", "ALLOCATE", "FALSE", "PRECISION", "ALTER", "FETCH", "PREPARE", "AND", "FIRST", "PRESERVE", "ANY", "FLOAT", "PRIMARY", "ARE", "FOR", "PRIOR", "AS", "FOREIGN", "PRIVILEGES", "ASC", "FORTRAN", "PROCEDURE", "ASSERTION", "FOUND", "PUBLIC", "AT", "FROM", "READ", "AUTHORIZATION", "FULL", "REAL", "AVG", "GET", "REFERENCES", "BEGIN", "GLOBAL", "RELATIVE", "BETWEEN", "GO", "RESTRICT", "BIT", "GOTO", "REVOKE", "BIT_LENGTH", "GRANT", "RIGHT", "BOTH", "GROUP", "ROLLBACK", "BY", "HAVING", "ROWS", "CASCADE", "HOUR", "SCHEMA", "CASCADED", "IDENTITY", "SCROLL", "CASE", "IMMEDIATE", "SECOND", "CAST", "IN", "SECTION", "CATALOG", "INCLUDE", "SELECT", "CHAR", "INDEX", "SESSION", "CHAR_LENGTH", "INDICATOR", "SESSION_USER", "CHARACTER", "INITIALLY", "SET", "CHARACTER_LENGTH", "INNER", "SIZE", "CHECK", "INPUT", "SMALLINT", "CLOSE", "INSENSITIVE", "SOME", "COALESCE", "INSERT", "SPACE", "COLLATE", "INT", "SQL", "COLLATION", "INTEGER", "SQLCA", "COLUMN", "INTERSECT", "SQLCODE", "COMMIT", "INTERVAL", "SQLERROR", "CONNECT", "INTO", "SQLSTATE", "CONNECTION", "IS", "SQLWARNING", "CONSTRAINT", "ISOLATION", "SUBSTRING", "CONSTRAINTS", "JOIN", "SUM", "CONTINUE", "KEY", "SYSTEM_USER", "CONVERT", "LANGUAGE", "TABLE", "CORRESPONDING", "LAST", "TEMPORARY", "COUNT", "LEADING", "THEN", "CREATE", "LEFT", "TIME", "CROSS", "LEVEL", "TIMESTAMP", "CURRENT", "LIKE", "TIMEZONE_HOUR", "CURRENT_DATE", "LOCAL", "TIMEZONE_MINUTE", "CURRENT_TIME", "LOWER", "TO", "CURRENT_TIMESTAMP", "MATCH", "TRAILING", "CURRENT_USER", "MAX", "TRANSACTION", "CURSOR", "MIN", "TRANSLATE", "DATE", "MINUTE", "TRANSLATION", "DAY", "MODULE", "TRIM", "DEALLOCATE", "MONTH", "TRUE", "DEC", "NAMES", "UNION", "DECIMAL", "NATIONAL", "UNIQUE", "DECLARE", "NATURAL", "UNKNOWN", "DEFAULT", "NCHAR", "UPDATE", "DEFERRABLE", "NEXT", "UPPER", "DEFERRED", "NO", "USAGE", "DELETE", "NONE", "USER", "DESC", "NOT", "USING", "DESCRIBE", "NULL", "VALUE", "DESCRIPTOR", "NULLIF", "VALUES", "DIAGNOSTICS", "NUMERIC", "VARCHAR", "DISCONNECT", "OCTET_LENGTH", "VARYING", "DISTINCT", "OF", "VIEW", "DOMAIN", "ON", "WHEN", "DOUBLE", "ONLY", "WHENEVER", "DROP", "OPEN", "WHERE", "ELSE", "OPTION", "WITH", "END", "OR", "WORK", "END-EXEC", "ORDER", "WRITE", "ESCAPE", "OUTER", "YEAR", "EXCEPT", "OUTPUT", "ZONE", "EXCEPTION"};
        TreeMap mySqlKeywordMap = new TreeMap();
        for (String allMySQLKeyword : allMySQLKeywords) {
            mySqlKeywordMap.put(allMySQLKeyword, null);
        }
        HashMap sql92KeywordMap = new HashMap(sql92Keywords.length);
        for (String sql92Keyword : sql92Keywords) {
            sql92KeywordMap.put(sql92Keyword, null);
        }
        Iterator sql92KeywordIterator = sql92KeywordMap.keySet().iterator();
        while (sql92KeywordIterator.hasNext()) {
            mySqlKeywordMap.remove(sql92KeywordIterator.next());
        }
        StringBuffer keywordBuf = new StringBuffer();
        sql92KeywordIterator = mySqlKeywordMap.keySet().iterator();
        if (sql92KeywordIterator.hasNext()) {
            keywordBuf.append(sql92KeywordIterator.next().toString());
        }
        while (sql92KeywordIterator.hasNext()) {
            keywordBuf.append(",");
            keywordBuf.append(sql92KeywordIterator.next().toString());
        }
        mysqlKeywordsThatArentSQL92 = keywordBuf.toString();
    }

    protected static enum TableType {
        LOCAL_TEMPORARY("LOCAL TEMPORARY"),
        SYSTEM_TABLE("SYSTEM TABLE"),
        SYSTEM_VIEW("SYSTEM VIEW"),
        TABLE("TABLE", new String[]{"BASE TABLE"}),
        VIEW("VIEW"),
        UNKNOWN("UNKNOWN");

        private String name;
        private byte[] nameAsBytes;
        private String[] synonyms;

        private TableType(String tableTypeName) {
            this(tableTypeName, null);
        }

        private TableType(String tableTypeName, String[] tableTypeSynonyms) {
            this.name = tableTypeName;
            this.nameAsBytes = tableTypeName.getBytes();
            this.synonyms = tableTypeSynonyms;
        }

        static TableType getTableTypeEqualTo(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.equalsTo(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }

        static TableType getTableTypeCompliantWith(String tableTypeName) {
            for (TableType tableType : TableType.values()) {
                if (!tableType.compliesWith(tableTypeName)) continue;
                return tableType;
            }
            return UNKNOWN;
        }

        String getName() {
            return this.name;
        }

        boolean equalsTo(String tableTypeName) {
            return this.name.equalsIgnoreCase(tableTypeName);
        }

        boolean compliesWith(String tableTypeName) {
            if (this.equalsTo(tableTypeName)) {
                return true;
            }
            if (null != this.synonyms) {
                for (String synonym : this.synonyms) {
                    if (!synonym.equalsIgnoreCase(tableTypeName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected class TableMetaDataKey
    implements Comparable<TableMetaDataKey> {
        String tableType;
        String tableCat;
        String tableSchem;
        String tableName;

        TableMetaDataKey(String tableType, String tableCat, String tableSchem, String tableName) {
            this.tableType = tableType == null ? "" : tableType;
            this.tableCat = tableCat == null ? "" : tableCat;
            this.tableSchem = tableSchem == null ? "" : tableSchem;
            this.tableName = tableName == null ? "" : tableName;
        }

        @Override
        public int compareTo(TableMetaDataKey tablesKey) {
            int compareResult = this.tableType.compareTo(tablesKey.tableType);
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.tableCat.compareTo(tablesKey.tableCat);
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.tableSchem.compareTo(tablesKey.tableSchem);
            if (compareResult != 0) {
                return compareResult;
            }
            return this.tableName.compareTo(tablesKey.tableName);
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return obj instanceof TableMetaDataKey && this.compareTo((TableMetaDataKey)obj) == 0;
        }
    }

    class TypeDescriptor {
        int bufferLength;
        int charOctetLength;
        Integer columnSize;
        short dataType;
        Integer decimalDigits;
        String isNullable;
        int nullability;
        int numPrecRadix = 10;
        String typeName;

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            StringTokenizer tokenizer;
            String fullMysqlType;
            if (typeInfo == null) {
                throw new SQLException("NULL typeinfo not supported.");
            }
            String mysqlType = typeInfo.indexOf("(") != -1 ? typeInfo.substring(0, typeInfo.indexOf("(")).trim() : typeInfo;
            int indexOfUnsignedInMysqlType = StringUtils.indexOfIgnoreCase(mysqlType, "unsigned");
            if (indexOfUnsignedInMysqlType != -1) {
                mysqlType = mysqlType.substring(0, indexOfUnsignedInMysqlType - 1);
            }
            boolean isUnsigned = false;
            if (StringUtils.indexOfIgnoreCase(typeInfo, "unsigned") != -1 && StringUtils.indexOfIgnoreCase(typeInfo, "set") != 0 && StringUtils.indexOfIgnoreCase(typeInfo, "enum") != 0) {
                fullMysqlType = mysqlType + " unsigned";
                isUnsigned = true;
            } else {
                fullMysqlType = mysqlType;
            }
            fullMysqlType = fullMysqlType.toUpperCase(Locale.ENGLISH);
            this.dataType = (short)MysqlDefs.mysqlToJavaType(mysqlType);
            this.typeName = fullMysqlType;
            if (StringUtils.startsWithIgnoreCase(typeInfo, "enum")) {
                String temp = typeInfo.substring(typeInfo.indexOf("("), typeInfo.lastIndexOf(")"));
                tokenizer = new StringTokenizer(temp, ",");
                int maxLength = 0;
                while (tokenizer.hasMoreTokens()) {
                    maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                }
                this.columnSize = maxLength;
                this.decimalDigits = null;
            } else if (StringUtils.startsWithIgnoreCase(typeInfo, "set")) {
                String temp = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.lastIndexOf(")"));
                tokenizer = new StringTokenizer(temp, ",");
                int maxLength = 0;
                int numElements = tokenizer.countTokens();
                if (numElements > 0) {
                    maxLength += numElements - 1;
                }
                while (tokenizer.hasMoreTokens()) {
                    String setMember = tokenizer.nextToken().trim();
                    if (setMember.startsWith("'") && setMember.endsWith("'")) {
                        maxLength += setMember.length() - 2;
                        continue;
                    }
                    maxLength += setMember.length();
                }
                this.columnSize = maxLength;
                this.decimalDigits = null;
            } else if (typeInfo.indexOf(",") != -1) {
                this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")).trim());
                this.decimalDigits = Integer.valueOf(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")).trim());
            } else {
                this.columnSize = null;
                this.decimalDigits = null;
                if ((StringUtils.indexOfIgnoreCase(typeInfo, "char") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "text") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "blob") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "binary") != -1 || StringUtils.indexOfIgnoreCase(typeInfo, "bit") != -1) && typeInfo.indexOf("(") != -1) {
                    int endParenIndex = typeInfo.indexOf(")");
                    if (endParenIndex == -1) {
                        endParenIndex = typeInfo.length();
                    }
                    this.columnSize = Integer.valueOf(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex).trim());
                    if (this.columnSize == 1 && StringUtils.startsWithIgnoreCase(typeInfo, "tinyint")) {
                        this.dataType = (short)-7;
                        this.typeName = "BIT";
                    }
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "tinyint")) {
                    if (typeInfo.indexOf("(1)") != -1) {
                        this.dataType = (short)-7;
                        this.typeName = "BIT";
                    } else {
                        this.columnSize = 3;
                        this.decimalDigits = 0;
                    }
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "smallint")) {
                    this.columnSize = 5;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "mediumint")) {
                    this.columnSize = isUnsigned ? 8 : 7;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "int")) {
                    this.columnSize = 10;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "integer")) {
                    this.columnSize = 10;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "bigint")) {
                    this.dataType = (short)-5;
                    this.columnSize = isUnsigned ? 20 : 19;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "int24")) {
                    this.columnSize = 19;
                    this.decimalDigits = 0;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "real")) {
                    this.columnSize = 12;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "float")) {
                    this.columnSize = 12;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "decimal")) {
                    this.columnSize = 12;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "numeric")) {
                    this.columnSize = 12;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "double")) {
                    this.columnSize = 22;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "char")) {
                    this.columnSize = 1;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "varchar")) {
                    this.columnSize = 255;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "timestamp")) {
                    this.columnSize = 19;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "datetime")) {
                    this.columnSize = 19;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "date")) {
                    this.columnSize = 10;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "time")) {
                    this.columnSize = 8;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "tinyblob")) {
                    this.columnSize = 255;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "blob")) {
                    this.columnSize = 65535;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "mediumblob")) {
                    this.columnSize = 0xFFFFFF;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "longblob")) {
                    this.columnSize = Integer.MAX_VALUE;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "tinytext")) {
                    this.columnSize = 255;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "text")) {
                    this.columnSize = 65535;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "mediumtext")) {
                    this.columnSize = 0xFFFFFF;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "longtext")) {
                    this.columnSize = Integer.MAX_VALUE;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "enum")) {
                    this.columnSize = 255;
                } else if (StringUtils.startsWithIgnoreCase(typeInfo, "set")) {
                    this.columnSize = 255;
                }
            }
            this.bufferLength = 65535;
            this.numPrecRadix = 10;
            if (nullabilityInfo != null) {
                switch (nullabilityInfo) {
                    case "YES": {
                        this.nullability = 1;
                        this.isNullable = "YES";
                        break;
                    }
                    case "UNKNOWN": {
                        this.nullability = 2;
                        this.isNullable = "";
                        break;
                    }
                    default: {
                        this.nullability = 0;
                        this.isNullable = "NO";
                        break;
                    }
                }
            } else {
                this.nullability = 0;
                this.isNullable = "NO";
            }
        }
    }

    protected class IndexMetaDataKey
    implements Comparable<IndexMetaDataKey> {
        Boolean columnNonUnique;
        Short columnType;
        String columnIndexName;
        Short columnOrdinalPosition;

        IndexMetaDataKey(boolean columnNonUnique, short columnType, String columnIndexName, short columnOrdinalPosition) {
            this.columnNonUnique = columnNonUnique;
            this.columnType = columnType;
            this.columnIndexName = columnIndexName;
            this.columnOrdinalPosition = columnOrdinalPosition;
        }

        @Override
        public int compareTo(IndexMetaDataKey indexInfoKey) {
            int compareResult = this.columnNonUnique.compareTo(indexInfoKey.columnNonUnique);
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.columnType.compareTo(indexInfoKey.columnType);
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.columnIndexName.compareTo(indexInfoKey.columnIndexName);
            if (compareResult != 0) {
                return compareResult;
            }
            return this.columnOrdinalPosition.compareTo(indexInfoKey.columnOrdinalPosition);
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return obj instanceof IndexMetaDataKey && this.compareTo((IndexMetaDataKey)obj) == 0;
        }
    }
}

