/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.client.Context;
import io.vitess.client.VTGateConnection;
import io.vitess.client.cursor.Cursor;
import io.vitess.client.cursor.CursorWithError;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessParameterMetaData;
import io.vitess.jdbc.VitessResultSet;
import io.vitess.jdbc.VitessStatement;
import io.vitess.mysql.DateTime;
import io.vitess.util.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VitessPreparedStatement
extends VitessStatement
implements PreparedStatement {
    private final String sql;
    private final Map<String, Object> bindVariables;
    private final List<Map<String, ?>> batchedArgs;
    private VitessParameterMetaData parameterMetadata;

    public VitessPreparedStatement(VitessConnection vitessConnection, String sql) throws SQLException {
        this(vitessConnection, sql, 1003, 1007);
    }

    public VitessPreparedStatement(VitessConnection vitessConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(vitessConnection, sql, resultSetType, resultSetConcurrency, 2);
    }

    public VitessPreparedStatement(VitessConnection vitessConnection, String sql, int autoGeneratedKeys) throws SQLException {
        this(vitessConnection, sql, 1003, 1007, autoGeneratedKeys);
    }

    public VitessPreparedStatement(VitessConnection vitessConnection, String sql, int resultSetType, int resultSetConcurrency, int autoGeneratedKeys) throws SQLException {
        super(vitessConnection, resultSetType, resultSetConcurrency);
        this.checkSQLNullOrEmpty(sql);
        this.bindVariables = new HashMap<String, Object>();
        this.sql = sql;
        this.generatedId = -1L;
        this.retrieveGeneratedKeys = autoGeneratedKeys == 1;
        this.batchedArgs = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        this.closeOpenResultSetAndResetCount();
        this.generatedId = -1L;
        VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
        try {
            Cursor cursor;
            if (this.vitessConnection.isSimpleExecute() && this.fetchSize == 0) {
                this.checkAndBeginTransaction();
                Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
                cursor = vtGateConn.execute(context, this.sql, this.bindVariables, this.vitessConnection.getVtSession()).checkedGet();
            } else {
                Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
                cursor = vtGateConn.streamExecute(context, this.sql, this.bindVariables, this.vitessConnection.getVtSession());
            }
            if (null == cursor) {
                throw new SQLException("Failed to execute this method");
            }
            this.vitessResultSet = new VitessResultSet(cursor, this);
        }
        finally {
            this.bindVariables.clear();
        }
        return this.vitessResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int truncatedUpdateCount;
        this.checkOpen();
        this.checkNotReadOnly();
        this.closeOpenResultSetAndResetCount();
        VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
        try {
            this.checkAndBeginTransaction();
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            Cursor cursor = vtGateConn.execute(context, this.sql, this.bindVariables, this.vitessConnection.getVtSession()).checkedGet();
            if (null == cursor) {
                throw new SQLException("Failed to execute this method");
            }
            if (null != cursor.getFields() && !cursor.getFields().isEmpty()) {
                throw new SQLException("ResultSet generation is not allowed through this method");
            }
            if (this.retrieveGeneratedKeys) {
                this.generatedId = cursor.getInsertId();
            }
            this.resultCount = cursor.getRowsAffected();
            truncatedUpdateCount = this.resultCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.resultCount;
        }
        finally {
            this.bindVariables.clear();
        }
        return truncatedUpdateCount;
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        this.closeOpenResultSetAndResetCount();
        if (!this.maybeSelect(this.sql)) {
            this.executeUpdate();
            return false;
        }
        this.executeQuery();
        return true;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.bindVariables.clear();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setByte(int parameterIndex, byte ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setShort(int parameterIndex, short ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setInt(int parameterIndex, int ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setLong(int parameterIndex, long ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setFloat(int parameterIndex, float ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, Float.valueOf(ignored));
    }

    @Override
    public void setDouble(int parameterIndex, double ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    public void setBigInteger(int parameterIndex, BigInteger ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setString(int parameterIndex, String ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] ignored) throws SQLException {
        this.checkOpen();
        this.bindVariables.put("v" + parameterIndex, ignored);
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.checkOpen();
        String dateString = DateTime.formatDate(date);
        this.bindVariables.put("v" + parameterIndex, dateString);
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.checkOpen();
        String timeString = DateTime.formatTime(time);
        this.bindVariables.put("v" + parameterIndex, timeString);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        String timestampString = DateTime.formatTimestamp(timestamp);
        this.bindVariables.put("v" + parameterIndex, timestampString);
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.checkOpen();
        String formattedDate = DateTime.formatDate(date, cal);
        this.bindVariables.put("v" + parameterIndex, formattedDate);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.checkOpen();
        String formattedTime = DateTime.formatTime(time, cal);
        this.bindVariables.put("v" + parameterIndex, formattedTime);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        this.checkOpen();
        String formattedTimestamp = DateTime.formatTimestamp(timestamp, cal);
        this.bindVariables.put("v" + parameterIndex, formattedTimestamp);
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        if (object == null) {
            this.setNull(parameterIndex, 0);
        } else if (object instanceof String) {
            this.setString(parameterIndex, (String)object);
        } else if (object instanceof Short) {
            this.setShort(parameterIndex, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(parameterIndex, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(parameterIndex, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(parameterIndex, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(parameterIndex, (Double)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(parameterIndex, (Byte)object);
        } else if (object instanceof Character) {
            this.setString(parameterIndex, String.valueOf(object));
        } else if (object instanceof Date) {
            this.setDate(parameterIndex, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(parameterIndex, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)object);
        } else if (object instanceof BigInteger) {
            this.setBigInteger(parameterIndex, (BigInteger)object);
        } else if (object instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])object);
        } else if (this.getConnection().getTreatUtilDateAsTimestamp() && object instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)object).getTime()));
        } else {
            throw new SQLException("Cannot infer the SQL type to use for an instance of " + object.getClass().getCanonicalName());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        this.batchedArgs.add(new HashMap<String, Object>(this.bindVariables));
        this.bindVariables.clear();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.batchedArgs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.checkNotReadOnly();
        ArrayList<String> batchedQueries = new ArrayList<String>();
        if (0 == this.batchedArgs.size()) {
            return new int[0];
        }
        try {
            VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
            this.retrieveGeneratedKeys = true;
            for (int i = 0; i < this.batchedArgs.size(); ++i) {
                batchedQueries.add(this.sql);
            }
            this.checkAndBeginTransaction();
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            List<CursorWithError> cursorWithErrorList = vtGateConn.executeBatch(context, batchedQueries, this.batchedArgs, this.vitessConnection.getVtSession()).checkedGet();
            if (null == cursorWithErrorList) {
                throw new SQLException("Failed to execute this method");
            }
            int[] nArray = this.generateBatchUpdateResult(cursorWithErrorList, batchedQueries);
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        if (this.parameterMetadata == null) {
            this.parameterMetadata = new VitessParameterMetaData(this.calculateParameterCount());
        }
        return this.parameterMetadata;
    }

    private int calculateParameterCount() throws SQLException {
        int statementStartPos;
        if (this.sql == null) {
            throw new SQLException("Illegal value for : sql null");
        }
        char quotedIdentifierChar = '`';
        char currentQuoteChar = '\u0000';
        boolean inQuotes = false;
        boolean inQuotedId = false;
        int statementCount = 0;
        int statementLength = this.sql.length();
        for (int i = statementStartPos = StringUtils.findStartOfStatement(this.sql); i < statementLength; ++i) {
            char curChar = this.sql.charAt(i);
            if (curChar == '\\' && i < statementLength - 1) {
                ++i;
                continue;
            }
            if (!inQuotes && curChar == quotedIdentifierChar) {
                inQuotedId = !inQuotedId;
            } else if (!inQuotedId) {
                if (inQuotes) {
                    if ((curChar == '\'' || curChar == '\"') && curChar == currentQuoteChar) {
                        if (i < statementLength - 1 && this.sql.charAt(i + 1) == currentQuoteChar) {
                            ++i;
                            continue;
                        }
                        inQuotes = !inQuotes;
                        currentQuoteChar = '\u0000';
                    }
                } else {
                    if (curChar == '#' || curChar == '-' && i + 1 < statementLength && this.sql.charAt(i + 1) == '-') {
                        int endOfStmt = statementLength - 1;
                        while (i < endOfStmt && (curChar = this.sql.charAt(i)) != '\r' && curChar != '\n') {
                            ++i;
                        }
                        continue;
                    }
                    if (curChar == '/' && i + 1 < statementLength) {
                        char nextChar = this.sql.charAt(i + 1);
                        if (nextChar == '*') {
                            for (int j = i += 2; j < statementLength; ++j) {
                                ++i;
                                nextChar = this.sql.charAt(j);
                                if (nextChar != '*' || j + 1 >= statementLength || this.sql.charAt(j + 1) != '/') continue;
                                if (++i < statementLength) {
                                    curChar = this.sql.charAt(i);
                                }
                                break;
                            }
                        }
                    } else if (curChar == '\'' || curChar == '\"') {
                        inQuotes = true;
                        currentQuoteChar = curChar;
                    }
                }
            }
            if (curChar != '?' || inQuotes || inQuotedId) continue;
            ++statementCount;
        }
        return statementCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setObject(int parameterIndex, Object parameterObject, int targetSqlType, int scaleOrLength) throws SQLException {
        if (null == parameterObject) {
            this.setNull(parameterIndex, 1111);
        } else {
            try {
                block1 : switch (targetSqlType) {
                    case 16: {
                        if (parameterObject instanceof Boolean) {
                            this.setBoolean(parameterIndex, (Boolean)parameterObject);
                            break;
                        }
                        if (parameterObject instanceof String) {
                            this.setBoolean(parameterIndex, "true".equalsIgnoreCase((String)parameterObject) || !"0".equalsIgnoreCase((String)parameterObject));
                            break;
                        }
                        if (parameterObject instanceof Number) {
                            int intValue = ((Number)parameterObject).intValue();
                            this.setBoolean(parameterIndex, intValue != 0);
                            break;
                        }
                        throw new SQLException("Conversion from" + parameterObject.getClass().getName() + "to Types.Boolean is not Possible");
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.setNumericObject(parameterIndex, parameterObject, targetSqlType, scaleOrLength);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        if (parameterObject instanceof BigDecimal) {
                            this.setString(parameterIndex, StringUtils.fixDecimalExponent(parameterObject.toString()));
                            break;
                        }
                        this.setString(parameterIndex, parameterObject.toString());
                        break;
                    }
                    case 2005: {
                        if (parameterObject instanceof Clob) {
                            this.setClob(parameterIndex, (Clob)parameterObject);
                            break;
                        }
                        this.setString(parameterIndex, parameterObject.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        if (parameterObject instanceof Blob) {
                            this.setBlob(parameterIndex, (Blob)parameterObject);
                            break;
                        }
                        this.setBytes(parameterIndex, (byte[])parameterObject);
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date parameterAsDate;
                        if (parameterObject instanceof String) {
                            ParsePosition pp = new ParsePosition(0);
                            SimpleDateFormat sdf = new SimpleDateFormat(StringUtils.getDateTimePattern((String)parameterObject, false), Locale.US);
                            parameterAsDate = ((DateFormat)sdf).parse((String)parameterObject, pp);
                        } else {
                            parameterAsDate = (java.util.Date)parameterObject;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (parameterAsDate instanceof Date) {
                                    this.setDate(parameterIndex, (Date)parameterAsDate);
                                    break block1;
                                }
                                this.setDate(parameterIndex, new Date(parameterAsDate.getTime()));
                                break block1;
                            }
                            case 93: {
                                if (parameterAsDate instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)parameterAsDate);
                                    break block1;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(parameterAsDate.getTime()));
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (parameterObject instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(StringUtils.getDateTimePattern((String)parameterObject, true), Locale.US);
                            this.setTime(parameterIndex, new Time(sdf.parse((String)parameterObject).getTime()));
                            break;
                        }
                        if (parameterObject instanceof Timestamp) {
                            Timestamp timestamp = (Timestamp)parameterObject;
                            this.setTime(parameterIndex, new Time(timestamp.getTime()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)parameterObject);
                        break;
                    }
                    default: {
                        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
                    }
                }
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.checkOpen();
        if (clob.length() > Integer.MAX_VALUE) {
            throw new SQLFeatureNotSupportedException(String.format("Clob size over %d not support", Integer.MAX_VALUE), "SQL Feature Not Supported");
        }
        this.bindVariables.put("v" + parameterIndex, clob.getSubString(1L, (int)clob.length()));
    }

    @Override
    public void setArray(int parameterIndex, Array ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setURL(int parameterIndex, URL ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setObject(int parameterIndex, Object parameterObject, int targetSqlType) throws SQLException {
        if (!(parameterObject instanceof BigDecimal)) {
            this.setObject(parameterIndex, parameterObject, targetSqlType, 0);
        } else {
            this.setObject(parameterIndex, parameterObject, targetSqlType, ((BigDecimal)parameterObject).scale());
        }
    }

    private void setNumericObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        Number numberParam;
        if (parameterObj instanceof Boolean) {
            numberParam = (Boolean)parameterObj != false ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (parameterObj instanceof String) {
            switch (targetSqlType) {
                case -7: {
                    if ("1".equals(parameterObj) || "0".equals(parameterObj)) {
                        numberParam = Integer.valueOf((String)parameterObj);
                        break;
                    }
                    boolean parameterAsBoolean = "true".equalsIgnoreCase((String)parameterObj);
                    numberParam = parameterAsBoolean ? Integer.valueOf(1) : Integer.valueOf(0);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    numberParam = Integer.valueOf((String)parameterObj);
                    break;
                }
                case -5: {
                    numberParam = Long.valueOf((String)parameterObj);
                    break;
                }
                case 7: {
                    numberParam = Float.valueOf((String)parameterObj);
                    break;
                }
                case 6: 
                case 8: {
                    numberParam = Double.valueOf((String)parameterObj);
                    break;
                }
                default: {
                    numberParam = new BigDecimal((String)parameterObj);
                    break;
                }
            }
        } else {
            numberParam = (Number)parameterObj;
        }
        switch (targetSqlType) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.setInt(parameterIndex, numberParam.intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, numberParam.longValue());
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, numberParam.floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, numberParam.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (numberParam instanceof BigDecimal) {
                    BigDecimal scaledBigDecimal;
                    try {
                        scaledBigDecimal = ((BigDecimal)numberParam).setScale(scale);
                    }
                    catch (ArithmeticException ex) {
                        try {
                            scaledBigDecimal = ((BigDecimal)numberParam).setScale(scale, 4);
                        }
                        catch (ArithmeticException arEx) {
                            throw new SQLException("Can't set the scale of '" + scale + "' for Decimal Argument" + numberParam);
                        }
                    }
                    this.setBigDecimal(parameterIndex, scaledBigDecimal);
                    break;
                }
                if (numberParam instanceof BigInteger) {
                    this.setBigInteger(parameterIndex, (BigInteger)numberParam);
                    break;
                }
                this.setBigDecimal(parameterIndex, new BigDecimal(numberParam.doubleValue()));
            }
        }
    }
}

