/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import io.vitess.client.cursor.Cursor;
import io.vitess.client.cursor.Row;
import io.vitess.client.cursor.SimpleCursor;
import io.vitess.jdbc.ConnectionProperties;
import io.vitess.jdbc.FieldWithMetadata;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessResultSetMetaData;
import io.vitess.jdbc.VitessStatement;
import io.vitess.proto.Query;
import io.vitess.util.Constants;
import io.vitess.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialClob;

public class VitessResultSet
implements ResultSet {
    private Cursor cursor;
    private List<FieldWithMetadata> fields;
    private VitessStatement vitessStatement;
    private boolean closed = false;
    private Row row;
    private int currentRow;
    private int maxRows;
    private int fetchSize;
    private int lastIndexRead = -1;

    public VitessResultSet(Cursor cursor) throws SQLException {
        this(cursor, null);
    }

    public VitessResultSet(Cursor cursor, VitessStatement vitessStatement) throws SQLException {
        if (null == cursor) {
            throw new SQLException("Cursor cannot be null");
        }
        this.cursor = cursor;
        this.vitessStatement = vitessStatement;
        try {
            this.fields = this.enhancedFieldsFromCursor(vitessStatement == null ? null : vitessStatement.getConnection());
        }
        catch (SQLException exc) {
            throw new SQLException("ResultSet initialization error", exc);
        }
        this.currentRow = 0;
        if (null != vitessStatement) {
            this.maxRows = vitessStatement.getMaxRows();
            this.fetchSize = vitessStatement.getFetchSize();
        }
    }

    public VitessResultSet(String[] columnNames, Query.Type[] columnTypes, String[][] data, ConnectionProperties connection) throws SQLException {
        if (columnNames.length != columnTypes.length) {
            throw new SQLException("Unable to build ResultSet");
        }
        Query.QueryResult.Builder queryResultBuilder = Query.QueryResult.newBuilder();
        for (int columnCounter = 0; columnCounter < columnNames.length; ++columnCounter) {
            Query.Field.Builder queryField = Query.Field.newBuilder().setName(columnNames[columnCounter]).setType(columnTypes[columnCounter]);
            queryResultBuilder.addFields(queryField.build());
        }
        if (null != data) {
            for (String[] rowData : data) {
                Query.Row.Builder queryRow = Query.Row.newBuilder();
                StringBuilder sb = new StringBuilder();
                for (String singleRowData : rowData) {
                    sb.append(singleRowData);
                    queryRow.addLengths(singleRowData.length());
                }
                queryRow.setValues(ByteString.copyFromUtf8(sb.toString()));
                queryResultBuilder.addRows(queryRow);
                sb.delete(0, sb.length());
            }
        }
        this.cursor = new SimpleCursor(queryResultBuilder.build());
        this.vitessStatement = null;
        try {
            this.fields = this.enhancedFieldsFromCursor(connection);
        }
        catch (SQLException exc) {
            throw new SQLException("ResultSet initialization error", exc);
        }
        this.currentRow = 0;
    }

    public VitessResultSet(String[] columnNames, Query.Type[] columnTypes, ArrayList<ArrayList<String>> data, VitessConnection connection) throws SQLException {
        if (columnNames.length != columnTypes.length) {
            throw new SQLException("Unable to build ResultSet");
        }
        Query.QueryResult.Builder queryResultBuilder = Query.QueryResult.newBuilder();
        for (int columnCounter = 0; columnCounter < columnNames.length; ++columnCounter) {
            Query.Field.Builder queryField = Query.Field.newBuilder().setName(columnNames[columnCounter]).setType(columnTypes[columnCounter]);
            queryResultBuilder.addFields(queryField.build());
        }
        for (ArrayList<String> rowData : data) {
            Query.Row.Builder queryRow = Query.Row.newBuilder();
            StringBuilder sb = new StringBuilder();
            for (String singleRowData : rowData) {
                if (null != singleRowData) {
                    sb.append(singleRowData);
                    queryRow.addLengths(singleRowData.length());
                    continue;
                }
                queryRow.addLengths(-1L);
            }
            queryRow.setValues(ByteString.copyFromUtf8(sb.toString()));
            queryResultBuilder.addRows(queryRow);
            sb.delete(0, sb.length());
        }
        this.cursor = new SimpleCursor(queryResultBuilder.build());
        this.vitessStatement = null;
        try {
            this.fields = this.enhancedFieldsFromCursor(connection);
        }
        catch (SQLException exc) {
            throw new SQLException("ResultSet initialization error", exc);
        }
        this.currentRow = 0;
    }

    private List<FieldWithMetadata> enhancedFieldsFromCursor(ConnectionProperties connection) throws SQLException {
        if (this.cursor == null || this.cursor.getFields() == null) {
            throw new SQLException("Cursor cannot be null");
        }
        List<Query.Field> rawFields = this.cursor.getFields();
        ArrayList<FieldWithMetadata> fields = new ArrayList<FieldWithMetadata>(rawFields.size());
        for (Query.Field field : rawFields) {
            fields.add(new FieldWithMetadata(connection, field));
        }
        return fields;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.maxRows > 0 && this.currentRow >= this.maxRows) {
            return false;
        }
        this.row = this.cursor.next();
        ++this.currentRow;
        return this.row != null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (Exception exc) {
                throw new SQLException("Getting Error while closing ResultSet");
            }
            finally {
                this.closed = true;
                this.cursor = null;
                this.vitessStatement = null;
                this.fields = null;
                this.row = null;
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkOpen();
        if (this.lastIndexRead == -1) {
            throw new SQLException("No column was accessed before calling this method");
        }
        return this.row.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        FieldWithMetadata field;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        Object object = this.row.getObject(columnIndex);
        String columnValue = object instanceof byte[] ? ((field = this.fields.get(columnIndex - 1)).hasConnectionProperties() && field.getConnectionProperties().isIncludeAllFields() ? this.convertBytesToString((byte[])object, field.getEncoding()) : new String((byte[])object)) : String.valueOf(object);
        return columnValue;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int bool;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return false;
        }
        FieldWithMetadata field = this.fields.get(columnIndex - 1);
        if (field.getVitessTypeValue() == 2073) {
            return this.byteArrayToBoolean(columnIndex);
        }
        String boolString = this.getString(columnIndex);
        try {
            bool = Integer.valueOf(boolString);
        }
        catch (NumberFormatException nfe) {
            return null != boolString && "true".equalsIgnoreCase(boolString.trim());
        }
        return bool > 0;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0;
        }
        Object object = this.row.getObject(columnIndex);
        if (object instanceof Byte) {
            return (Byte)object;
        }
        String byteString = this.getString(columnIndex);
        try {
            value = Byte.parseByte(byteString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0;
        }
        String shortString = this.getString(columnIndex);
        try {
            value = Short.parseShort(shortString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0;
        }
        String intString = this.getString(columnIndex);
        try {
            value = Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0L;
        }
        String longString = this.getString(columnIndex);
        try {
            value = Long.parseLong(longString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0.0f;
        }
        String floatString = this.getString(columnIndex);
        try {
            value = Float.parseFloat(floatString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return 0.0;
        }
        String doubleString = this.getString(columnIndex);
        try {
            value = Double.parseDouble(doubleString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(nfe);
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        String bigDecimalString = this.getString(columnIndex);
        try {
            value = new BigDecimal(bigDecimalString);
            value = value.setScale(scale, 4);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return value;
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        BigInteger value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        String bigIntegerString = this.getString(columnIndex);
        try {
            value = new BigInteger(bigIntegerString);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        byte[] value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        Object object = this.row.getObject(columnIndex);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        String bytesString = this.getString(columnIndex);
        try {
            value = bytesString.getBytes();
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return value;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        NullDateTime nullDateTime = this.getNullDateTime(columnIndex);
        return this.getNullableDate(columnIndex, nullDateTime, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        return this.row.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        NullDateTime nullDateTime = this.getNullDateTime(columnIndex);
        return this.getNullableDateTime(columnIndex, nullDateTime, null);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex, scale);
    }

    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigInteger(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new VitessResultSetMetaData(this.fields);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        Object retVal = this.row.getObject(columnIndex);
        FieldWithMetadata field = this.fields.get(columnIndex - 1);
        if (field.hasConnectionProperties() && field.getConnectionProperties().isIncludeAllFields() && retVal instanceof byte[]) {
            retVal = this.convertBytesIfPossible((byte[])retVal, field);
        }
        return retVal;
    }

    private Object convertBytesIfPossible(byte[] bytes, FieldWithMetadata field) throws SQLException {
        String encoding = field.getEncoding();
        switch (field.getJavaType()) {
            case -7: {
                if (!field.isSingleBit()) {
                    return bytes;
                }
                return this.byteArrayToBoolean(bytes);
            }
            case -1: 
            case 1: 
            case 12: {
                if (!field.isOpaqueBinary()) {
                    return this.convertBytesToString(bytes, encoding);
                }
                return bytes;
            }
            case -4: 
            case -3: 
            case -2: {
                return bytes;
            }
        }
        return this.convertBytesToString(bytes, encoding);
    }

    private String convertBytesToString(byte[] bytes, String encoding) throws SQLException {
        if (encoding == null) {
            return StringUtils.toString(bytes);
        }
        try {
            return StringUtils.toString(bytes, 0, bytes.length, encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new SQLException("Unsupported character encoding: " + encoding, exc);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.cursor.findColumn(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal value;
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        String bigDecimalString = this.getString(columnIndex);
        try {
            value = new BigDecimal(bigDecimalString);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.currentRow == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return this.currentRow == 1;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.currentRow;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Illegal value for fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        return this.vitessStatement;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.preAccessor(columnIndex);
        NullDateTime nullDateTime = this.getNullDateTime(columnIndex);
        return this.getNullableDate(columnIndex, nullDateTime, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        return this.row.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.preAccessor(columnIndex);
        NullDateTime nullDateTime = this.getNullDateTime(columnIndex);
        return this.getNullableDateTime(columnIndex, nullDateTime, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex, cal);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString(), cce);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkOpen();
        return iface.isInstance(this);
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("Result Set closed");
        }
    }

    private void preAccessor(int columnIndex) throws SQLException {
        this.checkOpen();
        if (columnIndex < 1 || columnIndex > this.fields.size()) {
            throw new SQLException("Invalid Column Index: " + columnIndex);
        }
        this.lastIndexRead = columnIndex;
    }

    private NullDateTime getNullDateTime(int columnIndex) throws SQLException {
        if (this.isNull(columnIndex)) {
            return NullDateTime.NULL;
        }
        if (!this.hasZeroDateTimePrefix(columnIndex)) {
            return NullDateTime.NO_CHANGE;
        }
        switch (this.vitessStatement.getConnection().getZeroDateTimeBehavior()) {
            case CONVERTTONULL: {
                return NullDateTime.NULL;
            }
            case EXCEPTION: {
                throw new SQLException("Zero timestamp cannot be represented as java.sql.Date: " + columnIndex);
            }
            case ROUND: {
                return NullDateTime.ROUND;
            }
        }
        return NullDateTime.NO_CHANGE;
    }

    private Date getNullableDate(int columnIndex, NullDateTime nullDateTime, Calendar cal) throws SQLException {
        switch (nullDateTime) {
            case NULL: {
                return null;
            }
            case ROUND: {
                return new Date(-1900, 0, 1);
            }
        }
        if (cal == null) {
            return this.row.getDate(columnIndex);
        }
        return this.row.getDate(columnIndex, cal);
    }

    private Timestamp getNullableDateTime(int columnIndex, NullDateTime nullDateTime, Calendar cal) throws SQLException {
        switch (nullDateTime) {
            case NULL: {
                return null;
            }
            case ROUND: {
                return new Timestamp(-1900, 0, 1, 0, 0, 0, 0);
            }
        }
        if (cal == null) {
            return this.row.getTimestamp(columnIndex);
        }
        return this.row.getTimestamp(columnIndex, cal);
    }

    private boolean hasZeroDateTimePrefix(int columnIndex) throws SQLException {
        return this.row.getRawValue(columnIndex).startsWith(Constants.ZERO_DATE_TIME_PREFIX);
    }

    private boolean isNull(int columnIndex) throws SQLException {
        return null == this.row.getObject(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        FieldWithMetadata field = this.fields.get(columnIndex - 1);
        switch (field.getJavaType()) {
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.row.getBinaryInputStream(columnIndex);
            }
        }
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateByte(int columnIndex, byte ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateShort(int columnIndex, short ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateInt(int columnIndex, int ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateLong(int columnIndex, long ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateFloat(int columnIndex, float ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateDouble(int columnIndex, double ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateString(int columnIndex, String ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateDate(int columnIndex, Date ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateTime(int columnIndex, Time ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateObject(int columnIndex, Object ignored, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateObject(int columnIndex, Object ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateByte(String columnLabel, byte ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateShort(String columnLabel, short ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateInt(String columnLabel, int ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateLong(String columnLabel, long ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateFloat(String columnLabel, float ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateDouble(String columnLabel, double ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateString(String columnLabel, String ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateDate(String columnLabel, Date ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateTime(String columnLabel, Time ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream ignored, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateObject(String columnLabel, Object ignored, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateObject(String columnLabel, Object ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        return new SerialClob(this.getString(columnIndex).toCharArray());
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getClob(columnIndex);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateRef(int columnIndex, Ref ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateArray(int columnIndex, Array ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateArray(String columnLabel, Array ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNString(int columnIndex, String ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNString(String columnLabel, String ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream ignored, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream ignored) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @VisibleForTesting
    List<FieldWithMetadata> getFields() {
        return this.fields;
    }

    private boolean byteArrayToBoolean(int columnIndex) throws SQLException {
        return this.byteArrayToBoolean(this.row.getObject(columnIndex));
    }

    private boolean byteArrayToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (((byte[])value).length == 0) {
            return false;
        }
        byte boolVal = ((byte[])value)[0];
        if (boolVal == 49) {
            return true;
        }
        if (boolVal == 48) {
            return false;
        }
        return boolVal == -1 || boolVal > 0;
    }

    protected static enum NullDateTime {
        NO_CHANGE,
        NULL,
        ROUND;

    }
}

