/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import com.google.common.collect.ImmutableList;
import io.vitess.jdbc.FieldWithMetadata;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class VitessResultSetMetaData
implements ResultSetMetaData {
    private List<FieldWithMetadata> fields;

    public VitessResultSetMetaData(List<FieldWithMetadata> fields) throws SQLException {
        this.fields = ImmutableList.copyOf(fields);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getField(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        switch (field.getJavaType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                if (field.isBinary() || !field.getConnectionProperties().isIncludeAllFields()) {
                    return true;
                }
                try {
                    String collationName = field.getCollation();
                    return collationName != null && !collationName.endsWith("_ci");
                }
                catch (SQLException exc) {
                    if (exc.getCause() instanceof ArrayIndexOutOfBoundsException) {
                        return false;
                    }
                    throw exc;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        if (!field.getConnectionProperties().isIncludeAllFields()) {
            return 2;
        }
        return field.isNotNull() ? 0 : 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getField(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        if (!field.getConnectionProperties().isIncludeAllFields()) {
            return 0;
        }
        return field.getColumnLength() / Math.max(field.getMaxBytesPerCharacter(), 1);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getField(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getField(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getField(column).getDatabase();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        if (!field.getConnectionProperties().isIncludeAllFields()) {
            return 0;
        }
        if (VitessResultSetMetaData.isDecimalType(field.getJavaType(), field.getVitessTypeValue())) {
            return field.getColumnLength() + field.getPrecisionAdjustFactor();
        }
        switch (field.getJavaType()) {
            case -4: 
            case -3: {
                return field.getColumnLength();
            }
        }
        return field.getColumnLength() / field.getMaxBytesPerCharacter();
    }

    private static boolean isDecimalType(int javaType, int vitessType) {
        switch (javaType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 5: {
                return vitessType != 785;
            }
        }
        return false;
    }

    @Override
    public int getScale(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        if (VitessResultSetMetaData.isDecimalType(field.getJavaType(), field.getVitessTypeValue())) {
            return this.getField(column).getDecimals();
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getField(column).getTable();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getField(column).getDatabase();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getField(column).getJavaType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        int vitessTypeValue = field.getVitessTypeValue();
        int javaType = field.getJavaType();
        switch (vitessTypeValue) {
            case 2073: {
                return "BIT";
            }
            case 18: {
                return "DECIMAL";
            }
            case 257: {
                return "TINYINT";
            }
            case 770: {
                return "TINYINT UNSIGNED";
            }
            case 259: {
                return "SMALLINT";
            }
            case 772: {
                return "SMALLINT UNSIGNED";
            }
            case 261: {
                return "MEDIUMINT";
            }
            case 774: {
                return "MEDIUMINT UNSIGNED";
            }
            case 263: {
                return "INT";
            }
            case 776: {
                return "INT UNSIGNED";
            }
            case 265: {
                return "BIGINT";
            }
            case 778: {
                return "BIGINT UNSIGNED";
            }
            case 1035: {
                return "FLOAT";
            }
            case 1036: {
                return "DOUBLE";
            }
            case 0: {
                return "NULL";
            }
            case 2061: {
                return "TIMESTAMP";
            }
            case 2062: {
                return "DATE";
            }
            case 2063: {
                return "TIME";
            }
            case 2064: {
                return "DATETIME";
            }
            case 10260: {
                return "BLOB";
            }
            case 6163: {
                return "TEXT";
            }
            case 6165: {
                return "VARCHAR";
            }
            case 10262: {
                if (javaType == -3) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case 10264: {
                if (javaType == -2) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case 6167: {
                return "CHAR";
            }
            case 2074: {
                return "ENUM";
            }
            case 785: {
                return "YEAR";
            }
            case 2075: {
                return "SET";
            }
            case 28: {
                return "TUPLE";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getField(column).isReadOnly();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        FieldWithMetadata field = this.getField(column);
        if (!field.getConnectionProperties().isIncludeAllFields()) {
            return null;
        }
        return this.getClassNameForJavaType(field.getJavaType(), field.getVitessTypeValue(), field.isUnsigned(), field.isBinary() || field.isBlob(), field.isOpaqueBinary(), field.getConnectionProperties().getYearIsDateType());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private FieldWithMetadata getField(int columnIndex) throws SQLException {
        if (columnIndex >= 1 && columnIndex <= this.fields.size()) {
            return this.fields.get(columnIndex - 1);
        }
        throw new SQLException("Invalid Column Index: " + columnIndex);
    }

    private String getClassNameForJavaType(int javaType, int vitessType, boolean isUnsigned, boolean isBinaryOrBlob, boolean isOpaqueBinary, boolean treatYearAsDate) {
        switch (javaType) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: {
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 5: {
                if (vitessType == 785) {
                    return treatYearAsDate ? "java.sql.Date" : "java.lang.Short";
                }
                if (isUnsigned) {
                    return "java.lang.Integer";
                }
                return "java.lang.Integer";
            }
            case 4: {
                if (!isUnsigned || vitessType == 774) {
                    return "java.lang.Integer";
                }
                return "java.lang.Long";
            }
            case -5: {
                if (!isUnsigned) {
                    return "java.lang.Long";
                }
                return "java.math.BigInteger";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                if (!isOpaqueBinary) {
                    return "java.lang.String";
                }
                return "[B";
            }
            case -4: 
            case -3: 
            case -2: {
                if (isBinaryOrBlob) {
                    return "[B";
                }
                return "java.lang.String";
            }
            case 91: {
                return treatYearAsDate ? "java.sql.Date" : "java.lang.Short";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }
}

