/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.client.Context;
import io.vitess.client.Proto;
import io.vitess.client.VTGateConnection;
import io.vitess.client.cursor.Cursor;
import io.vitess.client.cursor.CursorWithError;
import io.vitess.jdbc.ConnectionProperties;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessPreparedStatement;
import io.vitess.jdbc.VitessResultSet;
import io.vitess.proto.Query;
import io.vitess.proto.Vtrpc;
import io.vitess.util.StringUtils;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class VitessStatement
implements Statement {
    protected static final String[] ON_DUPLICATE_KEY_UPDATE_CLAUSE = new String[]{"ON", "DUPLICATE", "KEY", "UPDATE"};
    protected VitessResultSet vitessResultSet;
    protected VitessConnection vitessConnection;
    protected boolean closed;
    protected long resultCount;
    protected long queryTimeoutInMillis;
    protected int maxFieldSize = 65535;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected boolean retrieveGeneratedKeys = false;
    protected long generatedId = -1L;
    protected long[][] batchGeneratedKeys;
    private List<String> batchedArgs;

    public VitessStatement(VitessConnection vitessConnection) {
        this(vitessConnection, 1003, 1007);
    }

    public VitessStatement(VitessConnection vitessConnection, int resultSetType, int resultSetConcurrency) {
        this.vitessConnection = vitessConnection;
        this.queryTimeoutInMillis = vitessConnection.getTimeout();
        this.vitessResultSet = null;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.closed = false;
        this.resultCount = -1L;
        this.vitessConnection.registerStatement(this);
        this.batchedArgs = new ArrayList<String>();
        this.batchGeneratedKeys = null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Cursor cursor;
        this.checkOpen();
        this.checkSQLNullOrEmpty(sql);
        this.closeOpenResultSetAndResetCount();
        if (this instanceof VitessPreparedStatement) {
            throw new SQLException("This method cannot be called using this class object");
        }
        this.retrieveGeneratedKeys = false;
        this.generatedId = -1L;
        VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
        if (this.vitessConnection.isSimpleExecute() && this.fetchSize == 0 || this.vitessConnection.isInTransaction()) {
            this.checkAndBeginTransaction();
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            cursor = vtGateConn.execute(context, sql, null, this.vitessConnection.getVtSession()).checkedGet();
        } else {
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            cursor = vtGateConn.streamExecute(context, sql, null, this.vitessConnection.getVtSession());
        }
        if (null == cursor) {
            throw new SQLException("Failed to execute this method");
        }
        this.vitessResultSet = new VitessResultSet(cursor, this);
        return this.vitessResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.vitessResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (null != this.vitessResultSet) {
            return -1;
        }
        int truncatedUpdateCount = this.resultCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.resultCount;
        return truncatedUpdateCount;
    }

    @Override
    public void close() throws SQLException {
        SQLException postponedSQLException = null;
        if (!this.closed) {
            if (null != this.vitessConnection) {
                this.vitessConnection.unregisterStatement(this);
            }
            try {
                if (null != this.vitessResultSet) {
                    this.vitessResultSet.close();
                }
            }
            catch (SQLException ex) {
                postponedSQLException = ex;
            }
            this.vitessConnection = null;
            this.vitessResultSet = null;
            this.closed = true;
            if (null != postponedSQLException) {
                throw postponedSQLException;
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("Illegal value for max row");
        }
        this.maxRows = max;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return (int)(this.queryTimeoutInMillis / 1000L);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Illegal value for query timeout");
        }
        this.queryTimeoutInMillis = 0 == seconds ? this.vitessConnection.getTimeout() : (long)seconds * 1000L;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Illegal value for fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    @Override
    public VitessConnection getConnection() throws SQLException {
        this.checkOpen();
        return this.vitessConnection;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString(), cce);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkOpen();
        return iface.isInstance(this);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String[][] data;
        Query.Type[] columnTypes;
        String[] columnNames;
        block6: {
            block5: {
                this.checkOpen();
                if (!this.retrieveGeneratedKeys) {
                    throw new SQLException("Generated keys not requested. You need to specify Statement.RETURN_GENERATED_KEYS to Statement.executeUpdate() or Connection.prepareStatement()");
                }
                columnNames = new String[]{"GENERATED_KEY"};
                columnTypes = new Query.Type[]{Query.Type.UINT64};
                data = null;
                if (this.generatedId <= 0L) break block5;
                data = new String[(int)this.resultCount][1];
                int i = 0;
                while ((long)i < this.resultCount) {
                    data[i][0] = String.valueOf(this.generatedId + (long)i);
                    ++i;
                }
                break block6;
            }
            if (this.batchGeneratedKeys == null) break block6;
            long totalAffected = 0L;
            for (long[] batchGeneratedKey : this.batchGeneratedKeys) {
                long rowsAffected = batchGeneratedKey[1];
                totalAffected += rowsAffected;
            }
            data = new String[(int)totalAffected][1];
            int idx = 0;
            for (long[] batchGeneratedKey : this.batchGeneratedKeys) {
                long insertId = batchGeneratedKey[0];
                long rowsAffected = batchGeneratedKey[1];
                int j = 0;
                while ((long)j < rowsAffected) {
                    data[idx++][0] = String.valueOf(insertId + (long)j);
                    ++j;
                }
            }
        }
        return new VitessResultSet(columnNames, columnTypes, data, (ConnectionProperties)this.vitessConnection);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.checkNotReadOnly();
        this.checkSQLNullOrEmpty(sql);
        this.closeOpenResultSetAndResetCount();
        if (this instanceof VitessPreparedStatement) {
            throw new SQLException("This method cannot be called using this class object");
        }
        VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
        this.checkAndBeginTransaction();
        Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
        Cursor cursor = vtGateConn.execute(context, sql, null, this.vitessConnection.getVtSession()).checkedGet();
        if (null == cursor) {
            throw new SQLException("Failed to execute this method");
        }
        if (null != cursor.getFields() && !cursor.getFields().isEmpty()) {
            throw new SQLException("ResultSet generation is not allowed through this method");
        }
        if (autoGeneratedKeys == 1) {
            this.retrieveGeneratedKeys = true;
            this.generatedId = cursor.getInsertId();
        } else {
            this.retrieveGeneratedKeys = false;
            this.generatedId = -1L;
        }
        this.resultCount = cursor.getRowsAffected();
        int truncatedUpdateCount = this.resultCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.resultCount;
        return truncatedUpdateCount;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        this.checkSQLNullOrEmpty(sql);
        this.closeOpenResultSetAndResetCount();
        if (this instanceof VitessPreparedStatement) {
            throw new SQLException("This method cannot be called using this class object");
        }
        if (!this.maybeSelect(sql)) {
            this.executeUpdate(sql, autoGeneratedKeys);
            return false;
        }
        this.executeQuery(sql);
        return true;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this.checkSQLNullOrEmpty(sql);
        if (this instanceof VitessPreparedStatement) {
            throw new SQLException("This method cannot be called using this class object");
        }
        this.batchedArgs.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.batchedArgs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.checkNotReadOnly();
        if (0 == this.batchedArgs.size()) {
            return new int[0];
        }
        try {
            VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
            this.checkAndBeginTransaction();
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            List<CursorWithError> cursorWithErrorList = vtGateConn.executeBatch(context, this.batchedArgs, null, this.vitessConnection.getVtSession()).checkedGet();
            if (null == cursorWithErrorList) {
                throw new SQLException("Failed to execute this method");
            }
            this.retrieveGeneratedKeys = true;
            int[] nArray = this.generateBatchUpdateResult(cursorWithErrorList, this.batchedArgs);
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    protected void closeOpenResultSetAndResetCount() throws SQLException {
        try {
            if (null != this.vitessResultSet) {
                this.vitessResultSet.close();
            }
        }
        catch (SQLException ex) {
            throw new SQLException(ex);
        }
        finally {
            this.vitessResultSet = null;
            this.resultCount = -1L;
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("Statement is closed");
        }
    }

    protected void checkNotReadOnly() throws SQLException {
        if (this.vitessConnection.isReadOnly()) {
            throw new SQLException("Connection has been set to read only and an update was attempted");
        }
    }

    protected void checkSQLNullOrEmpty(String sql) throws SQLException {
        if (StringUtils.isNullOrEmptyWithoutWS(sql)) {
            throw new SQLException("SQL statement is not valid");
        }
    }

    protected int[] generateBatchUpdateResult(List<CursorWithError> cursorWithErrorList, List<String> batchedArgs) throws BatchUpdateException {
        int[] updateCounts = new int[cursorWithErrorList.size()];
        ArrayList<long[]> generatedKeys = new ArrayList<long[]>();
        Vtrpc.RPCError rpcError = null;
        String batchCommand = null;
        CursorWithError cursorWithError = null;
        for (int i = 0; i < cursorWithErrorList.size(); ++i) {
            cursorWithError = cursorWithErrorList.get(i);
            batchCommand = batchedArgs.get(i);
            if (null == cursorWithError.getError()) {
                try {
                    int truncatedUpdateCount;
                    long rowsAffected = cursorWithError.getCursor().getRowsAffected();
                    boolean queryBatchUpsert = false;
                    if (rowsAffected > Integer.MAX_VALUE) {
                        truncatedUpdateCount = Integer.MAX_VALUE;
                    } else if (this.sqlIsUpsert(batchCommand)) {
                        truncatedUpdateCount = 1;
                        queryBatchUpsert = true;
                    } else {
                        truncatedUpdateCount = (int)rowsAffected;
                    }
                    updateCounts[i] = truncatedUpdateCount;
                    long insertId = cursorWithError.getCursor().getInsertId();
                    if (!this.retrieveGeneratedKeys || queryBatchUpsert && insertId <= 0L) continue;
                    generatedKeys.add(new long[]{insertId, truncatedUpdateCount});
                }
                catch (SQLException ex) {
                    updateCounts[i] = -2;
                    if (!this.retrieveGeneratedKeys) continue;
                    generatedKeys.add(new long[]{-2L, -2L});
                }
                continue;
            }
            rpcError = cursorWithError.getError();
            updateCounts[i] = -3;
            if (!this.retrieveGeneratedKeys) continue;
            generatedKeys.add(new long[]{-3L, -3L});
        }
        if (null != rpcError) {
            int errno = Proto.getErrno(rpcError.getMessage());
            String sqlState = Proto.getSQLState(rpcError.getMessage());
            throw new BatchUpdateException(rpcError.toString(), sqlState, errno, updateCounts);
        }
        if (this.retrieveGeneratedKeys) {
            this.batchGeneratedKeys = (long[][])generatedKeys.toArray((T[])new long[generatedKeys.size()][2]);
        }
        return updateCounts;
    }

    private boolean sqlIsUpsert(String sql) {
        return StringUtils.indexOfIgnoreCase(0, sql, ON_DUPLICATE_KEY_UPDATE_CLAUSE, "\"'`", "\"'`", StringUtils.SEARCH_MODE__ALL) != -1;
    }

    protected boolean maybeSelect(String sql) {
        char firstNonWsCharOfQuery = StringUtils.firstAlphaCharUc(sql, StringUtils.findStartOfStatement(sql));
        return firstNonWsCharOfQuery == 'S';
    }

    protected void checkAndBeginTransaction() throws SQLException {
        if (!this.vitessConnection.getAutoCommit() && !this.vitessConnection.isInTransaction()) {
            Context context = this.vitessConnection.createContext(this.queryTimeoutInMillis);
            VTGateConnection vtGateConn = this.vitessConnection.getVtGateConn();
            vtGateConn.execute(context, "begin", null, this.vitessConnection.getVtSession()).checkedGet();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }
}

