/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.client.Context;
import io.vitess.client.RefreshableVTGateConnection;
import io.vitess.client.RpcClient;
import io.vitess.client.VTGateConnection;
import io.vitess.client.grpc.GrpcClientFactory;
import io.vitess.client.grpc.RetryingInterceptorConfig;
import io.vitess.client.grpc.tls.TlsOptions;
import io.vitess.jdbc.VitessConnection;
import io.vitess.jdbc.VitessJDBCUrl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VitessVTGateManager {
    private static Logger logger = LogManager.getLogger(VitessVTGateManager.class);
    private static ConcurrentHashMap<String, VTGateConnection> vtGateConnHashMap = new ConcurrentHashMap();
    private static Timer vtgateConnRefreshTimer = null;
    private static Timer vtgateClosureTimer = null;
    private static long vtgateClosureDelaySeconds = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void maybeStartClosureTimer(VitessConnection connection) {
        if (!connection.getRefreshClosureDelayed() || vtgateClosureTimer != null) return;
        Class<VitessVTGateManager> clazz = VitessVTGateManager.class;
        synchronized (VitessVTGateManager.class) {
            if (vtgateClosureTimer != null) return;
            vtgateClosureTimer = new Timer("vtgate-conn-closure", true);
            vtgateClosureDelaySeconds = connection.getRefreshClosureDelaySeconds();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getIdentifer(String hostname, int port, String userIdentifer, String keyspace) {
        return hostname + port + userIdentifer + keyspace;
    }

    private static void updateVtGateConnHashMap(String identifier, VitessJDBCUrl.HostInfo hostInfo, VitessConnection connection) {
        vtGateConnHashMap.put(identifier, VitessVTGateManager.getVtGateConn(hostInfo, connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshUpdatedSSLConnections(VitessJDBCUrl.HostInfo hostInfo, VitessConnection connection) {
        Class<VitessVTGateManager> clazz = VitessVTGateManager.class;
        synchronized (VitessVTGateManager.class) {
            int updatedCount = 0;
            for (Map.Entry<String, VTGateConnection> entry : vtGateConnHashMap.entrySet()) {
                RefreshableVTGateConnection existing;
                if (!(entry.getValue() instanceof RefreshableVTGateConnection) || !(existing = (RefreshableVTGateConnection)entry.getValue()).checkKeystoreUpdates()) continue;
                ++updatedCount;
                VTGateConnection old = vtGateConnHashMap.replace(entry.getKey(), VitessVTGateManager.getVtGateConn(hostInfo, connection));
                VitessVTGateManager.closeRefreshedConnection(old);
            }
            if (updatedCount > 0) {
                logger.info("refreshed {} vtgate connections due to keystore update", (Object)updatedCount);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void closeRefreshedConnection(final VTGateConnection old) {
        if (vtgateClosureTimer != null) {
            logger.info("{} Closing connection with a {} second delay", (Object)old, (Object)vtgateClosureDelaySeconds);
            vtgateClosureTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VitessVTGateManager.actuallyCloseRefreshedConnection(old);
                }
            }, TimeUnit.SECONDS.toMillis(vtgateClosureDelaySeconds));
        } else {
            VitessVTGateManager.actuallyCloseRefreshedConnection(old);
        }
    }

    private static void actuallyCloseRefreshedConnection(VTGateConnection old) {
        try {
            logger.info("{} Closing connection because it had been refreshed", (Object)old);
            old.close();
        }
        catch (IOException ioe) {
            logger.warn("Error closing VTGateConnection {}", (Object)old, (Object)ioe);
        }
    }

    private static String nullIf(String ifNull, String returnThis) {
        if (ifNull == null) {
            return returnThis;
        }
        return ifNull;
    }

    private static VTGateConnection getVtGateConn(VitessJDBCUrl.HostInfo hostInfo, VitessConnection connection) {
        Context context = connection.createContext(connection.getTimeout());
        RetryingInterceptorConfig retryingConfig = VitessVTGateManager.getRetryingInterceptorConfig(connection);
        GrpcClientFactory grpcClientFactory = new GrpcClientFactory(retryingConfig, connection.getUseTracing());
        if (connection.getUseSSL()) {
            TlsOptions tlsOptions = VitessVTGateManager.getTlsOptions(connection);
            RpcClient rpcClient = grpcClientFactory.createTls(context, hostInfo.toString(), tlsOptions);
            return new RefreshableVTGateConnection(rpcClient, tlsOptions.getKeyStore().getPath(), tlsOptions.getTrustStore().getPath());
        }
        RpcClient client = grpcClientFactory.create(context, hostInfo.toString());
        return new VTGateConnection(client);
    }

    private static TlsOptions getTlsOptions(VitessConnection con) {
        String keyStorePath = VitessVTGateManager.nullIf(con.getKeyStore(), System.getProperty("javax.net.ssl.keyStore"));
        String keyStorePassword = VitessVTGateManager.nullIf(con.getKeyStorePassword(), System.getProperty("javax.net.ssl.keyStorePassword"));
        String keyAlias = VitessVTGateManager.nullIf(con.getKeyAlias(), System.getProperty("javax.net.ssl.keyAlias"));
        String keyPassword = VitessVTGateManager.nullIf(con.getKeyPassword(), System.getProperty("javax.net.ssl.keyPassword"));
        String trustStorePath = VitessVTGateManager.nullIf(con.getTrustStore(), System.getProperty("javax.net.ssl.trustStore"));
        String trustStorePassword = VitessVTGateManager.nullIf(con.getTrustStorePassword(), System.getProperty("javax.net.ssl.trustStorePassword"));
        String trustAlias = VitessVTGateManager.nullIf(con.getTrustAlias(), System.getProperty("javax.net.ssl.trustAlias"));
        return new TlsOptions().keyStorePath(keyStorePath).keyStorePassword(keyStorePassword).keyAlias(keyAlias).keyPassword(keyPassword).trustStorePath(trustStorePath).trustStorePassword(trustStorePassword).trustAlias(trustAlias);
    }

    private static RetryingInterceptorConfig getRetryingInterceptorConfig(VitessConnection conn) {
        if (!conn.getGrpcRetriesEnabled().booleanValue()) {
            return RetryingInterceptorConfig.noOpConfig();
        }
        return RetryingInterceptorConfig.exponentialConfig(conn.getGrpcRetryInitialBackoffMillis(), conn.getGrpcRetryMaxBackoffMillis(), conn.getGrpcRetryBackoffMultiplier());
    }

    public static void close() throws SQLException {
        SQLException exception = null;
        for (VTGateConnection vtGateConn : vtGateConnHashMap.values()) {
            try {
                vtGateConn.close();
            }
            catch (IOException ioe) {
                exception = new SQLException(ioe.getMessage(), ioe);
            }
        }
        vtGateConnHashMap.clear();
        if (null != exception) {
            throw exception;
        }
    }

    public static class VTGateConnections {
        private List<String> vtGateIdentifiers = new ArrayList<String>();
        int counter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public VTGateConnections(final VitessConnection connection) {
            VitessVTGateManager.maybeStartClosureTimer(connection);
            Iterator<VitessJDBCUrl.HostInfo> iterator = connection.getUrl().getHostInfos().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Random random = new Random();
                    this.counter = random.nextInt(this.vtGateIdentifiers.size());
                    return;
                }
                final VitessJDBCUrl.HostInfo hostInfo = iterator.next();
                String identifier = VitessVTGateManager.getIdentifer(hostInfo.getHostname(), hostInfo.getPort(), connection.getUsername(), connection.getTarget());
                Class<VitessVTGateManager> clazz = VitessVTGateManager.class;
                // MONITORENTER : io.vitess.jdbc.VitessVTGateManager.class
                if (!vtGateConnHashMap.containsKey(identifier)) {
                    VitessVTGateManager.updateVtGateConnHashMap(identifier, hostInfo, connection);
                }
                if (connection.getUseSSL() && connection.getRefreshConnection() && vtgateConnRefreshTimer == null) {
                    logger.info("ssl vtgate connection detected -- installing connection refresh based on ssl keystore modification");
                    vtgateConnRefreshTimer = new Timer("ssl-refresh-vtgate-conn", true);
                    vtgateConnRefreshTimer.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            VitessVTGateManager.refreshUpdatedSSLConnections(hostInfo, connection);
                        }
                    }, TimeUnit.SECONDS.toMillis(connection.getRefreshSeconds()), TimeUnit.SECONDS.toMillis(connection.getRefreshSeconds()));
                }
                // MONITOREXIT : clazz
                this.vtGateIdentifiers.add(identifier);
            }
        }

        public VTGateConnection getVtGateConnInstance() {
            ++this.counter;
            this.counter %= this.vtGateIdentifiers.size();
            return (VTGateConnection)vtGateConnHashMap.get(this.vtGateIdentifiers.get(this.counter));
        }
    }
}

